/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name, @NotNull ElementFilter filter, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place, PsiFile placeFile) {
        super(filter, container);
        this.myResolvers = resolvers;
        this.myName = name;
        this.myPlace = place;
        this.myPlaceFile = placeFile;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult != null && cachedResult.length == 1 && this.stopAtFoundResult(cachedResult[0])) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName((PsiElement)element, (String)this.myName, (PsiElement)this.myPlace)) {
            return super.execute(element, state);
        }
        return true;
    }

    protected boolean stopAtFoundResult(JavaResolveResult cachedResult) {
        return cachedResult.isAccessible();
    }

    @Override
    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        this.add(new CandidateInfo(element, substitutor));
    }

    protected void add(CandidateInfo info) {
        this.myCachedResult = null;
        this.myResults.add(info);
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    @NotNull
    public JavaResolveResult[] getResult() {
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            if (!conflicts.isEmpty()) {
                for (PsiConflictResolver resolver : this.myResolvers) {
                    CandidateInfo candidate = resolver.resolveConflict(conflicts);
                    if (candidate == null) continue;
                    conflicts.clear();
                    conflicts.add(candidate);
                    break;
                }
            }
            this.myCachedResult = cachedResult = conflicts.toArray(JavaResolveResult.EMPTY_ARRAY);
        }
        return cachedResult;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }
}

