/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VariablesProcessor
implements PsiScopeProcessor,
ElementClassHint {
    private boolean myStaticScopeFlag;
    private final boolean myStaticSensitiveFlag;
    private final List<PsiVariable> myResultList;

    public VariablesProcessor(boolean staticSensitive) {
        this(staticSensitive, (List<PsiVariable>)new SmartList());
    }

    public VariablesProcessor(boolean staticSensitive, List<PsiVariable> list) {
        this.myStaticSensitiveFlag = staticSensitive;
        this.myResultList = list;
    }

    protected abstract boolean check(PsiVariable var1, ResolveState var2);

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind2) {
        return kind2 == ElementClassHint.DeclarationKind.VARIABLE || kind2 == ElementClassHint.DeclarationKind.FIELD || kind2 == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
        if (pe instanceof PsiVariable) {
            PsiVariable pvar = (PsiVariable)pe;
            if ((!this.myStaticSensitiveFlag || !this.myStaticScopeFlag || pvar.hasModifierProperty("static")) && this.check(pvar, state)) {
                this.myResultList.add(pvar);
            }
        }
        return true;
    }

    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        }
    }

    public int size() {
        return this.myResultList.size();
    }

    public PsiVariable getResult(int i) {
        return this.myResultList.get(i);
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return null;
    }
}

