/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.IncompleteHierarchyException;
import com.intellij.psi.stubsHierarchy.impl.StubResolver;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import java.util.Collections;
import java.util.Set;

abstract class QualifiedName {
    QualifiedName() {
    }

    abstract void resolveCandidates(StubResolver var1, Symbol.ClassSymbol var2, Set<? super Symbol.ClassSymbol> var3) throws IncompleteHierarchyException;

    static class Interned
    extends QualifiedName {
        final int id;

        Interned(int id) {
            this.id = id;
        }

        @Override
        void resolveCandidates(StubResolver resolver, Symbol.ClassSymbol place, Set<? super Symbol.ClassSymbol> result) throws IncompleteHierarchyException {
            Symbol.ClassSymbol[] candidates = resolver.findGlobalType(this.id);
            if (candidates.length == 0) {
                throw IncompleteHierarchyException.INSTANCE;
            }
            Collections.addAll(result, candidates);
        }
    }

    static class OfSingleComponent
    extends QualifiedName {
        final int shortName;

        OfSingleComponent(int shortName) {
            this.shortName = shortName;
        }

        @Override
        void resolveCandidates(StubResolver resolver, Symbol.ClassSymbol place, Set<? super Symbol.ClassSymbol> result) throws IncompleteHierarchyException {
            for (Symbol symbol : resolver.resolveUnqualified(place, this.shortName, false)) {
                if (!(symbol instanceof Symbol.ClassSymbol)) continue;
                result.add((Symbol.ClassSymbol)symbol);
            }
        }
    }

    static class OfComponents
    extends QualifiedName {
        final int[] components;

        OfComponents(int[] components) {
            this.components = components;
        }

        @Override
        void resolveCandidates(StubResolver resolver, Symbol.ClassSymbol place, Set<? super Symbol.ClassSymbol> result) throws IncompleteHierarchyException {
            for (Symbol symbol : resolver.resolveBase(place, this.components)) {
                if (!(symbol instanceof Symbol.ClassSymbol)) continue;
                result.add((Symbol.ClassSymbol)symbol);
            }
        }
    }
}

