/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.stubsHierarchy.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.AnchorRepository;
import org.jetbrains.annotations.NotNull;

public class StubClassAnchor
extends SmartClassAnchor {
    public static final StubClassAnchor[] EMPTY_ARRAY = new StubClassAnchor[0];
    public final int myId;
    public final int myFileId;
    final int myStubId;

    StubClassAnchor(int symbolId, int fileId, int stubId) {
        this.myId = symbolId;
        this.myFileId = fileId;
        this.myStubId = stubId;
    }

    @Override
    @NotNull
    public VirtualFile retrieveFile() {
        return AnchorRepository.retrieveFile(this.myFileId);
    }

    @Override
    @NotNull
    public PsiClass retrieveClass(@NotNull Project project) {
        return AnchorRepository.retrieveClass(project, this.myFileId, this.myStubId);
    }

    public int hashCode() {
        return this.myId;
    }

    public String toString() {
        return AnchorRepository.anchorToString(this.myStubId, this.myFileId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StubClassAnchor)) {
            return false;
        }
        StubClassAnchor anchor = (StubClassAnchor)o;
        return this.myId == anchor.myId && this.myFileId == anchor.myFileId && this.myStubId == anchor.myStubId;
    }
}

