/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.Imports;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.StubHierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.stubsHierarchy.impl.UnitInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class StubEnter {
    final Imports imports = new Imports();
    private final Symbols mySymbols;
    private final StubHierarchyConnector myStubHierarchyConnector;
    private ArrayList<Symbol.ClassSymbol> uncompleted = new ArrayList();

    StubEnter(Symbols symbols) {
        this.mySymbols = symbols;
        this.myStubHierarchyConnector = new StubHierarchyConnector(symbols);
    }

    Symbol.PackageSymbol readPackageName(DataInput in) throws IOException {
        Symbol.PackageSymbol pkg = this.mySymbols.myRootPackage;
        int qname = 0;
        int len = DataInputOutputUtil.readINT((DataInput)in);
        for (int i = 0; i < len; ++i) {
            int shortName = in.readInt();
            qname = NameEnvironment.qualifiedName(qname, shortName);
            pkg = this.mySymbols.enterPackage(qname, shortName, pkg);
        }
        return pkg;
    }

    Symbol.ClassSymbol classEnter(UnitInfo info, Symbol owner, int stubId, int mods, int name, Object superNames, int qname, int fileId) throws IOException {
        int flags = StubEnter.checkFlags(mods, info.isCompiled());
        Object supers = this.handleSpecialSupers(mods, superNames);
        Symbol.ClassSymbol classSymbol = this.mySymbols.enterClass(fileId, stubId, flags, name, owner, info, supers, qname);
        if (this.uncompleted != null) {
            this.uncompleted.add(classSymbol);
        }
        return classSymbol;
    }

    @Nullable
    Object handleSpecialSupers(int flags, Object superNames) {
        if (BitUtil.isSet((int)flags, (int)32)) {
            return NameEnvironment.java_lang_annotation_Annotation;
        }
        if (BitUtil.isSet((int)flags, (int)64)) {
            if (superNames == null) {
                return NameEnvironment.java_lang_Enum;
            }
            if (superNames instanceof QualifiedName) {
                return new QualifiedName[]{(QualifiedName)superNames, NameEnvironment.java_lang_Enum};
            }
            return ArrayUtil.append((Object[])((QualifiedName[])superNames), (Object)NameEnvironment.java_lang_Enum);
        }
        return superNames;
    }

    public void connect1() {
        for (Symbol.ClassSymbol classSymbol : this.uncompleted) {
            classSymbol.connect(this.myStubHierarchyConnector);
        }
        this.uncompleted = new ArrayList();
    }

    public void connect2() {
        for (Symbol.ClassSymbol classSymbol : this.uncompleted) {
            classSymbol.connect(this.myStubHierarchyConnector);
        }
        this.uncompleted = null;
    }

    private static int checkFlags(long flags, boolean compiled) {
        int mask = 0;
        if ((flags & 0x200L) != 0L) {
            mask |= 0x200;
        }
        if (compiled) {
            mask |= 0x80;
        }
        return mask;
    }
}

