/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.StubHierarchyIndexer;
import com.intellij.psi.stubsHierarchy.impl.HierarchyServiceImpl;
import com.intellij.psi.stubsHierarchy.impl.SerializedUnit;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class StubHierarchyIndex
extends FileBasedIndexExtension<Integer, SerializedUnit>
implements PsiDependentIndex {
    static final ID<Integer, SerializedUnit> INDEX_ID = ID.create((String)"jvm.hierarchy");

    @NotNull
    public ID<Integer, SerializedUnit> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<Integer, SerializedUnit, FileContent> getIndexer() {
        return inputData -> {
            for (StubHierarchyIndexer indexer : StubHierarchyIndexer.EP_NAME.getExtensionList()) {
                VirtualFile file;
                IndexTree.Unit unit = indexer.handlesFile(file = inputData.getFile()) ? indexer.indexFile((FileContent)inputData) : null;
                if (unit == null || unit.myDecls.length <= 0) continue;
                int[] keys = file.getFileType().isBinary() ? HierarchyServiceImpl.BINARY_KEYS : HierarchyServiceImpl.SOURCE_KEYS;
                return Collections.singletonMap(keys[((VirtualFileWithId)file).getId() % keys.length], new SerializedUnit(unit));
            }
            return Collections.emptyMap();
        };
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<SerializedUnit> getValueExternalizer() {
        return new DataExternalizer<SerializedUnit>(){

            public void save(@NotNull DataOutput out, SerializedUnit value2) throws IOException {
                byte[] bytes = value2.getSerializedBytes();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)bytes.length);
                out.write(bytes);
            }

            public SerializedUnit read(@NotNull DataInput in) throws IOException {
                byte[] bytes = new byte[DataInputOutputUtil.readINT((DataInput)in)];
                in.readFully(bytes);
                return new SerializedUnit(bytes);
            }
        };
    }

    public int getVersion() {
        return IndexTree.STUB_HIERARCHY_ENABLED ? 8 + StubHierarchyIndexer.EP_NAME.extensions().mapToInt(StubHierarchyIndexer::getVersion).sum() : 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file -> IndexTree.STUB_HIERARCHY_ENABLED && StubHierarchyIndexer.EP_NAME.extensions().anyMatch(indexer -> indexer.handlesFile(file)) && StubHierarchyIndex.isSourceOrLibrary(file);
    }

    private static boolean isSourceOrLibrary(VirtualFile file) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
            if (!index.isInLibraryClasses(file) && !index.isInSourceContent(file)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOnFileContent() {
        return true;
    }
}

