/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.AnchorRepository;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.UnitInfo;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Symbols {
    public final Symbol.PackageSymbol myRootPackage = new Symbol.PackageSymbol(null, 0, 0);
    private final AnchorRepository myClassAnchors = new AnchorRepository();
    private List<Symbol.ClassSymbol> myClassSymbols = new ArrayList<Symbol.ClassSymbol>(32768);
    private final TIntObjectHashMap<Symbol.PackageSymbol> myPackages = new TIntObjectHashMap();
    private final TIntObjectHashMap<Object> myClassSymbolsByNameId = new TIntObjectHashMap();

    protected Symbols() {
        this.myPackages.put(0, (Object)this.myRootPackage);
    }

    Symbol.PackageSymbol enterPackage(int qualifiedName, int shortName, Symbol.PackageSymbol owner) {
        Symbol.PackageSymbol p = (Symbol.PackageSymbol)this.myPackages.get(qualifiedName);
        if (p == null) {
            p = new Symbol.PackageSymbol(owner, qualifiedName, shortName);
            this.myPackages.put(qualifiedName, (Object)p);
        }
        return p;
    }

    @Nullable
    Symbol.PackageSymbol getPackage(int qualifiedName) {
        return (Symbol.PackageSymbol)this.myPackages.get(qualifiedName);
    }

    @NotNull
    Symbol.ClassSymbol[] getClassSymbols(int name) {
        Object cs = this.myClassSymbolsByNameId.get(name);
        if (cs == null) {
            return Symbol.ClassSymbol.EMPTY_ARRAY;
        }
        if (cs instanceof Symbol.ClassSymbol) {
            return new Symbol.ClassSymbol[]{(Symbol.ClassSymbol)cs};
        }
        return (Symbol.ClassSymbol[])cs;
    }

    Symbol.ClassSymbol enterClass(int fileId, int stubId, int flags, int shortName, Symbol owner, UnitInfo info, Object supers, int qualifiedName) {
        int anchorId = this.myClassAnchors.registerClass(fileId, stubId);
        Symbol.ClassSymbol c = new Symbol.ClassSymbol(anchorId, flags, owner, shortName, info, supers);
        this.myClassSymbols.add(c);
        if (qualifiedName != 0) {
            this.putClassByName(c, qualifiedName);
        }
        return c;
    }

    private void putClassByName(Symbol.ClassSymbol classSymbol, int nameId) {
        Object cs = this.myClassSymbolsByNameId.get(nameId);
        if (cs == null) {
            this.myClassSymbolsByNameId.put(nameId, (Object)classSymbol);
        } else if (cs instanceof Symbol.ClassSymbol) {
            this.myClassSymbolsByNameId.put(nameId, (Object)new Symbol.ClassSymbol[]{(Symbol.ClassSymbol)cs, classSymbol});
        } else {
            this.myClassSymbolsByNameId.put(nameId, (Object)ArrayUtil.append((Object[])((Symbol.ClassSymbol[])cs), (Object)classSymbol));
        }
    }

    SingleClassHierarchy createHierarchy() {
        Symbol.ClassSymbol[] array = this.myClassSymbols.toArray(Symbol.ClassSymbol.EMPTY_ARRAY);
        this.myClassSymbols = null;
        return new SingleClassHierarchy(array, this.myClassAnchors);
    }
}

