/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMatchers {
    private PsiMatchers() {
    }

    @NotNull
    public static PsiMatcherExpression hasName(final @NotNull String name) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasText(final @NotNull String text2) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text2.length()) {
                    return Boolean.FALSE;
                }
                return text2.equals(element.getText());
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasText(final String ... texts) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text2 = element.getText();
                return ArrayUtil.find((Object[])texts, (Object)text2) != -1;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final @NotNull Class<?> aClass) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final Class ... classes2) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass : classes2) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }
}

