/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.codeInsight.intention.impl.InlineStreamMapAction;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class StreamChainCallExtractor
implements ChainCallExtractor {
    @Override
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, PsiExpression expression2, PsiType expressionType) {
        if (!StreamApiUtil.isSupportedStreamElement(expressionType) || !InlineStreamMapAction.NEXT_METHODS.contains(call.getMethodExpression().getReferenceName()) || call.getMethodExpression().getQualifierExpression() == null) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || method.getParameterList().getParametersCount() != 1 || !InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.util.stream.BaseStream")) {
            return false;
        }
        if (method.getName().startsWith("flatMap")) {
            PsiType outType = StreamApiUtil.getStreamElementType(call.getType());
            if (expressionType instanceof PsiPrimitiveType && !expressionType.equals(outType)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String fixCallName(PsiMethodCallExpression call, PsiType inType) {
        PsiType outType = StreamApiUtil.getStreamElementType(call.getType(), false);
        String methodName = Objects.requireNonNull(call.getMethodExpression().getReferenceName());
        if (methodName.startsWith("flatMap")) {
            return Objects.requireNonNull(StreamRefactoringUtil.getFlatMapOperationName(inType, outType));
        }
        if (methodName.startsWith("map")) {
            return StreamRefactoringUtil.getMapOperationName(inType, outType);
        }
        return methodName;
    }

    @Override
    public String getMethodName(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        String shortcutMappingMethod = StreamRefactoringUtil.getShortcutMappingMethod(variable, expressionType, (PsiElement)expression2);
        if (shortcutMappingMethod != null) {
            return shortcutMappingMethod;
        }
        return StreamRefactoringUtil.getMapOperationName(variable.getType(), expressionType);
    }

    @Override
    public String buildChainCall(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        return StreamRefactoringUtil.generateMapOperation(variable, expressionType, (PsiElement)expression2);
    }
}

