/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeClassSignature.ChangeClassSigntaureViewDescriptor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeClassSignatureProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor");
    private PsiClass myClass;
    private final TypeParameterInfo[] myNewSignature;

    public ChangeClassSignatureProcessor(Project project, PsiClass aClass, TypeParameterInfo[] newSignature) {
        super(project);
        this.myClass = aClass;
        this.myNewSignature = newSignature;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        LOG.assertTrue(elements.length == 1);
        LOG.assertTrue(elements[0] instanceof PsiClass);
        this.myClass = (PsiClass)elements[0];
    }

    @NotNull
    protected String getCommandName() {
        return ChangeClassSignatureDialog.REFACTORING_NAME;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new ChangeClassSigntaureViewDescriptor(this.myClass);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        PsiTypeParameter[] parameters2 = this.myClass.getTypeParameters();
        HashMap<String, TypeParameterInfo> infos = new HashMap<String, TypeParameterInfo>();
        for (TypeParameterInfo info : this.myNewSignature) {
            String newName = info.getName(parameters2);
            TypeParameterInfo existing = (TypeParameterInfo)infos.get(newName);
            if (existing != null) {
                conflicts.putValue((Object)this.myClass, (Object)(RefactoringUIUtil.getDescription((PsiElement)this.myClass, (boolean)false) + " already contains type parameter " + newName));
            }
            infos.put(newName, info);
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        boolean hadTypeParameters = this.myClass.hasTypeParameters();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)projectScope, (boolean)false)) {
            PsiJavaCodeReferenceElement referenceElement;
            PsiElement parent;
            if (!(reference.getElement() instanceof PsiJavaCodeReferenceElement) || (parent = (referenceElement = (PsiJavaCodeReferenceElement)reference.getElement()).getParent()) instanceof PsiTypeElement && (parent.getParent() instanceof PsiInstanceOfExpression || parent.getParent() instanceof PsiClassObjectAccessExpression) || parent instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)((PsiNewExpression)parent)) || !(parent instanceof PsiTypeElement) && !(parent instanceof PsiNewExpression) && !(parent instanceof PsiAnonymousClass) && !(parent instanceof PsiReferenceList) || hadTypeParameters && referenceElement.getTypeParameters().length <= 0) continue;
            result.add(new UsageInfo((PsiQualifiedReferenceElement)referenceElement));
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            a.finish();
        }
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.changeClassSignature";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myClass);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myClass);
        return data;
    }

    private void doRefactoring(UsageInfo[] usages) throws IncorrectOperationException {
        final PsiTypeParameter[] typeParameters = this.myClass.getTypeParameters();
        final boolean[] toRemoveParms = this.detectRemovedParameters(typeParameters);
        for (UsageInfo usage : usages) {
            LOG.assertTrue(usage.getElement() instanceof PsiJavaCodeReferenceElement);
            this.processUsage(usage, typeParameters, toRemoveParms);
        }
        final HashMap supersMap = new HashMap();
        this.myClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                int i;
                super.visitTypeElement(typeElement);
                PsiType type2 = typeElement.getType();
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
                if (psiClass instanceof PsiTypeParameter && (i = ArrayUtil.find((Object[])typeParameters, (Object)psiClass)) >= 0 && i < toRemoveParms.length && toRemoveParms[i]) {
                    supersMap.put(typeElement, psiClass.getSuperClass());
                }
            }
        });
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        for (Map.Entry classEntry : supersMap.entrySet()) {
            ((PsiTypeElement)classEntry.getKey()).replace((PsiElement)elementFactory.createTypeElement((PsiType)elementFactory.createType((PsiClass)classEntry.getValue())));
        }
        this.changeClassSignature(typeParameters, toRemoveParms);
    }

    private void changeClassSignature(PsiTypeParameter[] originalTypeParameters, boolean[] toRemoveParms) throws IncorrectOperationException {
        ArrayList<PsiTypeParameter> newTypeParameters = new ArrayList<PsiTypeParameter>();
        for (TypeParameterInfo info : this.myNewSignature) {
            newTypeParameters.add(info.getTypeParameter(originalTypeParameters, this.myProject));
        }
        PsiTypeParameterList parameterList = this.myClass.getTypeParameterList();
        ChangeSignatureUtil.synchronizeList(parameterList, newTypeParameters, TypeParameterList.INSTANCE, toRemoveParms);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)parameterList);
    }

    private boolean[] detectRemovedParameters(PsiTypeParameter[] original) {
        boolean[] toRemove2 = new boolean[original.length];
        Arrays.fill(toRemove2, true);
        for (TypeParameterInfo info : this.myNewSignature) {
            if (!(info instanceof TypeParameterInfo.Existing)) continue;
            toRemove2[((TypeParameterInfo.Existing)info).getParameterIndex()] = false;
        }
        return toRemove2;
    }

    private void processUsage(UsageInfo usage, PsiTypeParameter[] original, boolean[] toRemove2) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject());
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)usage.getElement();
        assert (referenceElement != null) : usage;
        PsiSubstitutor usageSubstitutor = this.determineUsageSubstitutor(referenceElement);
        PsiReferenceParameterList referenceParameterList = referenceElement.getParameterList();
        assert (referenceParameterList != null) : referenceElement;
        PsiTypeElement[] oldValues = referenceParameterList.getTypeParameterElements();
        if (oldValues.length != original.length) {
            return;
        }
        ArrayList<PsiTypeElement> newValues = new ArrayList<PsiTypeElement>();
        for (TypeParameterInfo info : this.myNewSignature) {
            if (info instanceof TypeParameterInfo.Existing) {
                newValues.add(oldValues[((TypeParameterInfo.Existing)info).getParameterIndex()]);
                continue;
            }
            PsiType type2 = ((TypeParameterInfo.New)info).getDefaultValue().getType(this.myClass.getLBrace(), PsiManager.getInstance((Project)this.myProject));
            PsiTypeElement newValue = factory.createTypeElement(usageSubstitutor.substitute(type2));
            newValues.add(newValue);
        }
        ChangeSignatureUtil.synchronizeList(referenceParameterList, newValues, ReferenceParameterList.INSTANCE, toRemove2);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)referenceParameterList);
    }

    private PsiSubstitutor determineUsageSubstitutor(PsiJavaCodeReferenceElement referenceElement) {
        PsiType[] typeArguments = referenceElement.getTypeParameters();
        PsiSubstitutor usageSubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] typeParameters = this.myClass.getTypeParameters();
        if (typeParameters.length == typeArguments.length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                usageSubstitutor = usageSubstitutor.put(typeParameters[i], typeArguments[i]);
            }
        }
        return usageSubstitutor;
    }

    private static class TypeParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiTypeParameterList, PsiTypeParameter> {
        private static final TypeParameterList INSTANCE = new TypeParameterList();

        private TypeParameterList() {
        }

        @Override
        public List<PsiTypeParameter> getChildren(PsiTypeParameterList psiTypeParameterList) {
            return Arrays.asList(psiTypeParameterList.getTypeParameters());
        }
    }

    private static class ReferenceParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiReferenceParameterList, PsiTypeElement> {
        private static final ReferenceParameterList INSTANCE = new ReferenceParameterList();

        private ReferenceParameterList() {
        }

        @Override
        public List<PsiTypeElement> getChildren(PsiReferenceParameterList list) {
            return Arrays.asList(list.getTypeParameterElements());
        }
    }
}

