/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ExceptionsTableModel
extends AbstractTableModel
implements EditableModel {
    private List<PsiTypeCodeFragment> myTypeCodeFragments;
    private final PsiElement myContext;
    private List<ThrownExceptionInfo> myExceptionInfos;

    public ExceptionsTableModel(PsiElement context) {
        this.myContext = context;
    }

    public ThrownExceptionInfo[] getThrownExceptions() {
        return this.myExceptionInfos.toArray(new ThrownExceptionInfo[0]);
    }

    public void addRow() {
        this.myExceptionInfos.add(new JavaThrownExceptionInfo());
        this.myTypeCodeFragments.add(this.createParameterTypeCodeFragment("", this.myContext));
        this.fireTableRowsInserted(this.myTypeCodeFragments.size() - 1, this.myTypeCodeFragments.size() - 1);
    }

    public void removeRow(int index) {
        this.myExceptionInfos.remove(index);
        this.myTypeCodeFragments.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void exchangeRows(int index1, int index2) {
        Collections.swap(this.myExceptionInfos, index1, index2);
        Collections.swap(this.myTypeCodeFragments, index1, index2);
        if (index1 < index2) {
            this.fireTableRowsUpdated(index1, index2);
        } else {
            this.fireTableRowsUpdated(index2, index1);
        }
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.myTypeCodeFragments.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.myTypeCodeFragments.get(rowIndex);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return RefactoringBundle.message((String)"column.name.type");
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return true;
        }
        throw new IllegalArgumentException();
    }

    public void setTypeInfos(PsiMethod method) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        this.myTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>(referencedTypes.length);
        this.myExceptionInfos = new ArrayList<ThrownExceptionInfo>(referencedTypes.length);
        for (int i = 0; i < referencedTypes.length; ++i) {
            CanonicalTypes.Type typeWrapper = CanonicalTypes.createTypeWrapper((PsiType)referencedTypes[i]);
            PsiTypeCodeFragment typeCodeFragment = this.createParameterTypeCodeFragment(typeWrapper.getTypeText(), (PsiElement)method.getThrowsList());
            typeWrapper.addImportsTo((JavaCodeFragment)typeCodeFragment);
            this.myTypeCodeFragments.add(typeCodeFragment);
            this.myExceptionInfos.add(new JavaThrownExceptionInfo(i, referencedTypes[i]));
        }
    }

    @NotNull
    private PsiTypeCodeFragment createParameterTypeCodeFragment(String typeText, PsiElement context) {
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)this.myContext.getProject());
        return factory.createTypeCodeFragment(typeText, context, true, 2);
    }

    @NotNull
    public PsiTypeCodeFragment[] getTypeCodeFragments() {
        return this.myTypeCodeFragments.toArray(new PsiTypeCodeFragment[0]);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

