/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inCallers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaMemberNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JavaMethodNode
extends JavaMemberNode<PsiMethod> {
    protected JavaMethodNode(PsiMethod method, Set<PsiMethod> called, Project project, Runnable cancelCallback) {
        super(method, called, project, cancelCallback);
    }

    protected MemberNodeBase<PsiMethod> createNode(PsiMethod caller, HashSet<PsiMethod> called) {
        return new JavaMethodNode(caller, (Set<PsiMethod>)called, this.myProject, this.myCancelCallback);
    }

    protected List<PsiMethod> computeCallers() {
        PsiReference[] refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)((PsiMethod)this.myMethod)).toArray((Object[])PsiReference.EMPTY_ARRAY);
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() instanceof PsiSuperExpression) continue;
            PsiElement enclosingContext = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
            if (enclosingContext instanceof PsiMethod && !result.contains(enclosingContext) && !((PsiMethod)this.getMember()).equals(enclosingContext) && !this.myCalled.contains(this.getMember()) && Arrays.stream(((PsiMethod)enclosingContext).findDeepestSuperMethods()).anyMatch(method -> !method.isWritable())) {
                result.add((PsiMethod)enclosingContext);
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            PsiMethod method2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
            if (result.contains(method2)) continue;
            result.add(method2);
        }
        return result;
    }
}

