/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ConvertToInstanceMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"convert.to.instance.method.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MakeMethodStaticHandler invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        boolean noArgConstructor;
        if (elements.length != 1 || !(elements[0] instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)elements[0];
        if (!method.hasModifierProperty("static")) {
            String message2 = RefactoringBundle.message((String)"convertToInstanceMethod.method.is.not.static", (Object[])new Object[]{method.getName()});
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        ArrayList<Object> targetQualifiers = new ArrayList<Object>();
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        for (PsiParameter parameter2 : parameters2) {
            PsiType type2 = parameter2.getType();
            if (!(type2 instanceof PsiClassType)) continue;
            classTypesFound = true;
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            if (!method.getManager().isInProject((PsiElement)psiClass)) continue;
            targetQualifiers.add(parameter2);
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || containingClass.getQualifiedName() == null) {
            return;
        }
        String className = containingClass.getName();
        PsiMethod[] constructors = containingClass.getConstructors();
        boolean bl = noArgConstructor = constructors.length == 0 || Arrays.stream(constructors).anyMatch(constructor -> constructor.getParameterList().isEmpty());
        if (noArgConstructor) {
            targetQualifiers.add("this / new " + className + "()");
        }
        if (targetQualifiers.isEmpty()) {
            String message3 = !classTypesFound ? RefactoringBundle.message((String)"convertToInstanceMethod.no.parameters.with.reference.type") : (!resolvableClassesFound ? RefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parametres.have.unknown.types") : RefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parameters.are.not.in.project"));
            message3 = message3 + " and containing class doesn't have default constructor";
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message3), (String)REFACTORING_NAME, (String)"refactoring.convertToInstanceMethod");
            return;
        }
        new ConvertToInstanceMethodDialog(method, ArrayUtil.toObjectArray(targetQualifiers)).show();
    }
}

