/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodUtil {
    private static final Key<PsiMethod> RESOLVE_TARGET_KEY = Key.create((String)"RESOLVE_TARGET_KEY");
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.extractMethod.ExtractMethodUtil");

    private ExtractMethodUtil() {
    }

    static Map<PsiMethodCallExpression, PsiMethod> encodeOverloadTargets(PsiClass targetClass, SearchScope processConflictsScope, String overloadName, PsiElement extractedFragment) {
        HashMap<PsiMethodCallExpression, PsiMethod> ret = new HashMap<PsiMethodCallExpression, PsiMethod>();
        ExtractMethodUtil.encodeInClass(targetClass, overloadName, extractedFragment, ret);
        ClassInheritorsSearch.search((PsiClass)targetClass, (SearchScope)processConflictsScope, (boolean)true).forEach(inheritor -> {
            ExtractMethodUtil.encodeInClass(inheritor, overloadName, extractedFragment, ret);
            return true;
        });
        return ret;
    }

    private static void encodeInClass(PsiClass aClass, String overloadName, PsiElement extractedFragment, Map<PsiMethodCallExpression, PsiMethod> ret) {
        PsiMethod[] overloads;
        for (PsiMethod overload : overloads = aClass.findMethodsByName(overloadName, false)) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)overload)) {
                PsiElement element = ref.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiMethodCallExpression)) continue;
                PsiMethodCallExpression call = (PsiMethodCallExpression)parent;
                if (PsiTreeUtil.isAncestor((PsiElement)extractedFragment, (PsiElement)element, (boolean)false)) {
                    call.putCopyableUserData(RESOLVE_TARGET_KEY, (Object)overload);
                    continue;
                }
                ret.put(call, overload);
            }
        }
    }

    public static void decodeOverloadTargets(Map<PsiMethodCallExpression, PsiMethod> oldResolves, PsiMethod extracted, PsiElement oldFragment) {
        PsiCodeBlock body2 = extracted.getBody();
        assert (body2 != null);
        JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiMethod target = (PsiMethod)expression2.getCopyableUserData(RESOLVE_TARGET_KEY);
                if (target != null) {
                    expression2.putCopyableUserData(RESOLVE_TARGET_KEY, null);
                    try {
                        ExtractMethodUtil.addCastsToEnsureResolveTarget(target, expression2);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        };
        body2.accept((PsiElementVisitor)visitor);
        oldFragment.accept((PsiElementVisitor)visitor);
        for (Map.Entry<PsiMethodCallExpression, PsiMethod> entry : oldResolves.entrySet()) {
            try {
                ExtractMethodUtil.addCastsToEnsureResolveTarget(entry.getValue(), entry.getKey());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public static void addCastsToEnsureResolveTarget(@NotNull PsiMethod oldTarget, @NotNull PsiMethodCallExpression call) throws IncorrectOperationException {
        PsiParameter[] oldParameters;
        PsiMethod newTarget = call.resolveMethod();
        PsiManager manager = oldTarget.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (!manager.areElementsEquivalent((PsiElement)oldTarget, (PsiElement)newTarget) && (oldParameters = oldTarget.getParameterList().getParameters()).length > 0) {
            PsiTypeCastExpression cast;
            PsiMethodCallExpression copy = (PsiMethodCallExpression)call.copy();
            PsiExpression[] args = copy.getArgumentList().getExpressions();
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                PsiType paramType = i < oldParameters.length ? oldParameters[i].getType() : oldParameters[oldParameters.length - 1].getType();
                cast = (PsiTypeCastExpression)factory.createExpressionFromText("(a)b", null);
                PsiTypeElement typeElement = cast.getCastType();
                assert (typeElement != null);
                typeElement.replace((PsiElement)factory.createTypeElement(paramType));
                PsiExpression operand2 = cast.getOperand();
                assert (operand2 != null);
                operand2.replace((PsiElement)arg);
                arg.replace((PsiElement)cast);
            }
            args = copy.getArgumentList().getExpressions();
            PsiExpression[] oldArgs = call.getArgumentList().getExpressions();
            for (int i = 0; i < args.length; ++i) {
                PsiExpression oldArg = oldArgs[i];
                cast = (PsiTypeCastExpression)args[i];
                if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)cast)) continue;
                oldArg.replace((PsiElement)cast);
            }
        }
    }
}

