/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReusedLocalVariable {
    @NotNull
    private final String myName;
    @Nullable
    private final String myTempName;
    @NotNull
    private final String myType;
    private final boolean myReuseValue;

    public ReusedLocalVariable(@NotNull String name, @Nullable String tempName, @NotNull String type2, boolean reuseValue) {
        assert (reuseValue == (tempName != null));
        this.myName = name;
        this.myTempName = tempName;
        this.myType = type2;
        this.myReuseValue = reuseValue;
    }

    public String getDeclarationText() {
        String initText = this.myReuseValue ? " = " + this.myTempName : "";
        return this.myType + " " + this.myName + initText + ";";
    }

    public String getAssignmentText() {
        return this.myTempName + " = " + this.myName + ";";
    }

    public String getTempDeclarationText() {
        return this.myType + " " + this.myTempName + ";";
    }

    public boolean reuseValue() {
        return this.myReuseValue;
    }
}

