/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.VariableData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableDataSnapshot
extends AbstractVariableData {
    @Nullable
    final SmartPsiElementPointer<PsiVariable> myVariable;
    @Nullable
    final SmartTypePointer myType;

    public VariableDataSnapshot(@NotNull VariableData data, @NotNull Project project) {
        this(data.variable, data.type, data.name, data.originalName, data.passAsParameter, project);
    }

    public VariableDataSnapshot(@Nullable PsiVariable variable, @Nullable PsiType type2, String name, String originalName, boolean passAsParameter, @NotNull Project project) {
        this.myVariable = variable != null ? SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)variable) : null;
        this.myType = type2 != null ? SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(type2) : null;
        this.name = name;
        this.originalName = originalName;
        this.passAsParameter = passAsParameter;
    }

    @Nullable
    public VariableData getData() {
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            PsiType type2 = this.getType();
            VariableData data = new VariableData(variable, type2);
            data.name = this.name;
            data.originalName = this.originalName;
            data.passAsParameter = this.passAsParameter;
            return data;
        }
        return null;
    }

    @Nullable
    PsiVariable getVariable() {
        return this.myVariable != null ? (PsiVariable)this.myVariable.getElement() : null;
    }

    @Nullable
    PsiType getType() {
        return this.myType != null ? this.myType.getType() : null;
    }
}

