/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

class ElementsRange {
    private final PsiElement myStart;
    private final PsiElement myEnd;

    ElementsRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        this.myStart = start;
        this.myEnd = end;
    }

    ElementsRange(@NotNull PsiElement[] elements) {
        this.myStart = elements[0];
        this.myEnd = elements[elements.length - 1];
    }

    public TextRange getTextRange() {
        if (this.myStart == this.myEnd) {
            return this.myStart.getTextRange();
        }
        return new TextRange(this.myStart.getTextRange().getStartOffset(), this.myEnd.getTextRange().getEndOffset());
    }

    public ElementsRange findCopyInFile(@NotNull PsiFile file) {
        PsiElement copyStart = ElementsRange.findCopyInFile(file, this.myStart);
        PsiElement copyEnd = ElementsRange.findCopyInFile(file, this.myEnd);
        if (copyStart != null && copyEnd != null) {
            return new ElementsRange(copyStart, copyEnd);
        }
        return null;
    }

    private static PsiElement findCopyInFile(@NotNull PsiFile file, @NotNull PsiElement element) {
        TextRange textRange = element.getTextRange();
        return CodeInsightUtil.findElementInRange(file, textRange.getStartOffset(), textRange.getEndOffset(), element.getClass());
    }
}

