/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.preview.ElementsRange;
import com.intellij.refactoring.extractMethod.preview.ExtractableFragment;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FragmentNode
extends DefaultMutableTreeNode
implements Comparable<FragmentNode> {
    private final TextChunk[] myTextChunks;
    private final TextChunk myLineNumberChunk;
    private final int myOffset;
    private final ExtractableFragment myFragment;
    private boolean myValid = true;

    protected FragmentNode(@NotNull PsiElement start, @NotNull PsiElement end, @NotNull ExtractableFragment fragment) {
        this.myTextChunks = this.createTextChunks(start);
        this.myLineNumberChunk = FragmentNode.createNumberChunk(start, end);
        this.myOffset = start.getTextRange().getStartOffset();
        this.myFragment = fragment;
        this.setAllowsChildren(false);
    }

    public TextChunk[] getTextChunks() {
        return this.myTextChunks;
    }

    public TextChunk getLineNumberChunk() {
        return this.myLineNumberChunk;
    }

    @NotNull
    protected TextChunk[] createTextChunks(@NotNull PsiElement element) {
        UsageInfo2UsageAdapter usageAdapter = new UsageInfo2UsageAdapter(new UsageInfo(element));
        PsiFile file = element.getContainingFile();
        TextRange range = element.getTextRange();
        return ChunkExtractor.getExtractor((PsiFile)file).createTextChunks(usageAdapter, (CharSequence)file.getText(), range.getStartOffset(), range.getEndOffset(), false, new ArrayList());
    }

    private static TextChunk createNumberChunk(@NotNull PsiElement start, @NotNull PsiElement end) {
        Document document = PsiDocumentManager.getInstance((Project)start.getProject()).getDocument(start.getContainingFile());
        if (document != null) {
            int endLine;
            int startLine = FragmentNode.getLineNumber(document, start.getTextRange().getStartOffset()) + 1;
            String lineText = startLine == (endLine = FragmentNode.getLineNumber(document, end.getTextRange().getEndOffset()) + 1) ? Integer.toString(startLine) : startLine + ".." + endLine;
            EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
            return new TextChunk(colorsScheme.getAttributes(UsageTreeColors.USAGE_LOCATION), lineText + "  ");
        }
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.myFragment.getNavigatable();
    }

    public boolean isExcluded() {
        return false;
    }

    public synchronized boolean isValid() {
        return this.myValid;
    }

    public synchronized void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Nullable
    public TextRange getTextRange() {
        return this.myFragment.getTextRange();
    }

    @Nullable
    public ElementsRange getElementsRange() {
        return this.myFragment.getElementsRange();
    }

    private static int getLineNumber(@NotNull Document document, int offset) {
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (offset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(offset);
    }

    @Override
    public int compareTo(@NotNull FragmentNode o) {
        return this.myOffset - o.myOffset;
    }

    @Override
    public String toString() {
        if (this.myTextChunks == null) {
            return "";
        }
        String lineNumber = this.myLineNumberChunk != null ? this.myLineNumberChunk.getText().trim() + ":" : "";
        return Stream.of(this.myTextChunks).map(TextChunk::getText).collect(Collectors.joining("", lineNumber, ""));
    }
}

