/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.extractMethod.preview.ExtractableFragment;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class MethodNode
extends FragmentNode {
    private final Icon myIcon;

    MethodNode(@NotNull PsiMethod method) {
        super((PsiElement)method, (PsiElement)method, new ExtractableFragment(PsiElement.EMPTY_ARRAY));
        this.myIcon = method.getIcon(0);
        this.setAllowsChildren(false);
    }

    @Override
    @NotNull
    protected TextChunk[] createTextChunks(@NotNull PsiElement element) {
        assert (element instanceof PsiMethod);
        Project project = element.getProject();
        PsiJavaFile file = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("A.java", (Language)JavaLanguage.INSTANCE, (CharSequence)("class A{" + element.getText() + "}"));
        PsiMethod psiMethod = file.getClasses()[0].getMethods()[0];
        UsageInfo2UsageAdapter usageAdapter = new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiMethod));
        TextRange range = psiMethod.getTextRange();
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        int startOffset = identifier != null ? identifier.getTextRange().getStartOffset() : range.getStartOffset();
        int endOffset = Math.min(psiMethod.getParameterList().getTextRange().getEndOffset(), range.getEndOffset());
        return ChunkExtractor.getExtractor((PsiFile)file).createTextChunks(usageAdapter, (CharSequence)file.getText(), startOffset, endOffset, false, new ArrayList());
    }

    public Icon getIcon() {
        return this.myIcon;
    }
}

