/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class PreviewDiffRequest
extends SimpleDiffRequest {
    private static final Logger LOG = Logger.getInstance(PreviewDiffRequest.class);
    private final Map<FragmentNode, Couple<TextRange>> myLinesBounds;
    private final Consumer<? super FragmentNode> mySelectNode;
    private CaretTracker myCaretTracker;
    private boolean myInitialized;

    PreviewDiffRequest(@NotNull Map<FragmentNode, Couple<TextRange>> linesBounds, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull Consumer<? super FragmentNode> selectNode) {
        super(null, content1, content2, null, null);
        this.myLinesBounds = linesBounds;
        this.mySelectNode = selectNode;
    }

    public void setViewer(FrameDiffTool.DiffViewer viewer) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread(), (Object)"EDT only");
        this.myCaretTracker = viewer instanceof UnifiedDiffViewer ? new UnifiedCaretTracker((UnifiedDiffViewer)viewer) : (viewer instanceof SimpleDiffViewer ? new SimpleCaretTracker((SimpleDiffViewer)viewer) : null);
    }

    public void onNodeSelected(@NotNull FragmentNode node) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread(), (Object)"EDT only");
        Couple<TextRange> bounds = this.myLinesBounds.get(node);
        if (bounds != null && this.myCaretTracker != null) {
            this.myCaretTracker.selectBounds(bounds);
        }
    }

    public void onInitialized() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread(), (Object)"EDT only");
        this.myInitialized = true;
    }

    class SimpleCaretTracker
    extends CaretTracker<SimpleDiffViewer> {
        private final CaretListener myListener1;
        private final CaretListener myListener2;

        protected SimpleCaretTracker(SimpleDiffViewer viewer) {
            super(PreviewDiffRequest.this, (DiffViewerBase)viewer);
            this.myListener1 = new CaretTracker.MyCaretListener(c -> (TextRange)c.getFirst());
            this.myListener2 = new CaretTracker.MyCaretListener(c -> (TextRange)c.getSecond());
        }

        protected void onInit() {
            ((SimpleDiffViewer)this.myViewer).getEditor1().getCaretModel().addCaretListener(this.myListener1);
            ((SimpleDiffViewer)this.myViewer).getEditor2().getCaretModel().addCaretListener(this.myListener2);
        }

        protected void onDispose() {
            ((SimpleDiffViewer)this.myViewer).getEditor1().getCaretModel().removeCaretListener(this.myListener1);
            ((SimpleDiffViewer)this.myViewer).getEditor2().getCaretModel().removeCaretListener(this.myListener2);
        }

        @Override
        protected void selectBounds(Couple<TextRange> bounds) {
            if (this.myMoveCaret) {
                this.setCaretPosition(((SimpleDiffViewer)this.myViewer).getEditor1(), (TextRange)bounds.getFirst());
                this.setCaretPosition(((SimpleDiffViewer)this.myViewer).getEditor2(), (TextRange)bounds.getSecond());
            }
        }
    }

    class UnifiedCaretTracker
    extends CaretTracker<UnifiedDiffViewer> {
        private final CaretListener myListener;

        protected UnifiedCaretTracker(UnifiedDiffViewer viewer) {
            super(PreviewDiffRequest.this, (DiffViewerBase)viewer);
            this.myListener = new CaretTracker.MyCaretListener(c -> (TextRange)c.getFirst());
        }

        protected void onInit() {
            EditorEx editor = ((UnifiedDiffViewer)this.myViewer).getEditor();
            editor.getCaretModel().addCaretListener(this.myListener);
        }

        protected void onDispose() {
            EditorEx editor = ((UnifiedDiffViewer)this.myViewer).getEditor();
            editor.getCaretModel().removeCaretListener(this.myListener);
        }

        @Override
        protected void selectBounds(Couple<TextRange> bounds) {
            if (this.myMoveCaret) {
                this.setCaretPosition(((UnifiedDiffViewer)this.myViewer).getEditor(), (TextRange)bounds.getFirst());
            }
        }
    }

    static abstract class CaretTracker<V extends DiffViewerBase>
    extends DiffViewerListener {
        protected final V myViewer;
        protected boolean myMoveCaret = true;
        final /* synthetic */ PreviewDiffRequest this$0;

        protected CaretTracker(V viewer) {
            this.this$0 = this$0;
            this.myViewer = viewer;
            viewer.addListener((DiffViewerListener)this);
        }

        protected abstract void selectBounds(Couple<TextRange> var1);

        protected void setCaretPosition(EditorEx editor, TextRange range) {
            CaretModel caretModel = editor.getCaretModel();
            int offset = caretModel.getOffset();
            if (!range.contains(offset)) {
                caretModel.moveToOffset(range.getStartOffset());
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }

        protected class MyCaretListener
        implements CaretListener {
            private final Function<? super Couple<TextRange>, ? extends TextRange> mySideGetter;

            public MyCaretListener(Function<? super Couple<TextRange>, ? extends TextRange> sideGetter) {
                this.mySideGetter = sideGetter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (!CaretTracker.this.this$0.myInitialized) {
                    return;
                }
                CaretTracker.this.myMoveCaret = false;
                try {
                    int newOffset = e.getEditor().logicalPositionToOffset(e.getNewPosition());
                    for (Map.Entry entry : CaretTracker.this.this$0.myLinesBounds.entrySet()) {
                        TextRange range = this.mySideGetter.apply((Couple<TextRange>)entry.getValue());
                        if (!range.containsOffset(newOffset)) continue;
                        CaretTracker.this.this$0.mySelectNode.accept(entry.getKey());
                        break;
                    }
                }
                finally {
                    CaretTracker.this.myMoveCaret = true;
                }
            }
        }
    }
}

