/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.TextChunk;
import com.intellij.util.ui.UIUtil;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewTreeRenderer
extends ColoredTreeCellRenderer {
    private static final EditorColorsScheme ourColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
    private static final SimpleTextAttributes ourInvalidAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)ourColorsScheme.getAttributes(UsageTreeColors.INVALID_PREFIX));
    private static final SimpleTextAttributes ourInvalidAttributesDarcula = new SimpleTextAttributes(null, DarculaColors.RED, null, ourInvalidAttributes.getStyle());

    PreviewTreeRenderer() {
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object object;
        if (value2 instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)value2;
            this.setIcon(methodNode.getIcon());
            this.appendText(methodNode);
        } else if (value2 instanceof FragmentNode) {
            FragmentNode node = (FragmentNode)value2;
            this.appendText(node);
        }
        if (value2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof String) {
            this.append((String)object, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private void appendText(@NotNull FragmentNode node) {
        if (node.isValid()) {
            this.append(node.getLineNumberChunk(), node);
        } else {
            SimpleTextAttributes attributes = UIUtil.isUnderDarcula() ? ourInvalidAttributesDarcula : ourInvalidAttributes;
            this.append("Invalid ", PreviewTreeRenderer.patchMainTextAttrs(attributes, node));
        }
        for (TextChunk textChunk : node.getTextChunks()) {
            this.append(textChunk, node);
        }
    }

    private void append(@Nullable TextChunk textChunk, @NotNull FragmentNode node) {
        if (textChunk != null) {
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            this.append(textChunk.getText(), PreviewTreeRenderer.patchMainTextAttrs(attributes, node), true);
        }
    }

    private static SimpleTextAttributes patchMainTextAttrs(@NotNull SimpleTextAttributes attributes, @NotNull FragmentNode node) {
        if (node.isExcluded()) {
            return attributes.derive(attributes.getStyle() | 4, null, null, null);
        }
        return attributes;
    }
}

