/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.refactoring.extractMethodObject.reflect.ConstructorReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodReferenceReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeReflectionAccessor
implements ReflectionAccessor {
    private final List<ReflectionAccessor> myAccessors = new ArrayList<ReflectionAccessor>();

    private CompositeReflectionAccessor() {
    }

    private void registerAccessor(@NotNull ReflectionAccessor accessor) {
        this.myAccessors.add(accessor);
    }

    public static ReflectionAccessor createAccessorToEverything(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        CompositeReflectionAccessor compositeAccessor = new CompositeReflectionAccessor();
        compositeAccessor.registerAccessor(new FieldReflectionAccessor(psiClass, elementFactory));
        compositeAccessor.registerAccessor(new MethodReflectionAccessor(psiClass, elementFactory));
        compositeAccessor.registerAccessor(new ConstructorReflectionAccessor(psiClass, elementFactory));
        compositeAccessor.registerAccessor(new MethodReferenceReflectionAccessor(psiClass, elementFactory));
        return compositeAccessor;
    }

    @Override
    public void accessThroughReflection(@NotNull PsiElement element) {
        for (ReflectionAccessor accessor : this.myAccessors) {
            accessor.accessThroughReflection(element);
        }
    }
}

