/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReferenceReflectionAccessorBase;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReflectionAccessor
extends ReferenceReflectionAccessorBase<FieldDescriptor> {
    private static final Logger LOG = Logger.getInstance(FieldReflectionAccessor.class);

    public FieldReflectionAccessor(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        super(psiClass, elementFactory);
    }

    @Override
    @Nullable
    protected FieldDescriptor createDescriptor(@NotNull PsiReferenceExpression expression2) {
        PsiField field;
        PsiElement resolved = expression2.resolve();
        if (resolved instanceof PsiField && !Objects.equals((field = (PsiField)resolved).getContainingClass(), this.getOuterClass()) && FieldReflectionAccessor.needReplace(field, expression2)) {
            return new FieldDescriptor(field, expression2);
        }
        return null;
    }

    @Override
    protected void grantAccess(@NotNull FieldDescriptor descriptor) {
        PsiElement parent = descriptor.expression.getParent();
        if (parent instanceof PsiAssignmentExpression && Objects.equals(descriptor.expression, ((PsiAssignmentExpression)parent).getLExpression())) {
            this.grantUpdateAccess((PsiAssignmentExpression)parent, descriptor);
        } else {
            this.grantReadAccess(descriptor);
        }
    }

    private void grantReadAccess(@NotNull FieldDescriptor descriptor) {
        PsiClass outerClass = this.getOuterClass();
        PsiMethod newMethod = this.createPsiMethod(descriptor, FieldAccessType.GET);
        if (newMethod == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        String qualifier = FieldReflectionAccessor.qualify(descriptor);
        String methodCall = newMethod.getName() + "(" + (qualifier == null ? "null" : qualifier) + ", null)";
        descriptor.expression.replace((PsiElement)this.getElementFactory().createExpressionFromText(methodCall, (PsiElement)descriptor.expression));
    }

    private void grantUpdateAccess(@NotNull PsiAssignmentExpression assignmentExpression, @NotNull FieldDescriptor descriptor) {
        PsiClass outerClass = this.getOuterClass();
        PsiMethod newMethod = this.createPsiMethod(descriptor, FieldAccessType.SET);
        if (newMethod == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        PsiExpression rightExpression = assignmentExpression.getRExpression();
        if (rightExpression == null) {
            LOG.warn("Expression representing a new field value not found");
            return;
        }
        String newValue = rightExpression.getText();
        String qualifier = FieldReflectionAccessor.qualify(descriptor);
        String args = (qualifier == null ? "null" : qualifier) + ", " + newValue;
        String methodCallExpression = newMethod.getName() + "(" + args + ")";
        PsiExpression newMethodCallExpression = this.getElementFactory().createExpressionFromText(methodCallExpression, (PsiElement)descriptor.expression);
        assignmentExpression.replace((PsiElement)newMethodCallExpression);
    }

    @Nullable
    private PsiMethod createPsiMethod(@NotNull FieldDescriptor descriptor, FieldAccessType accessType) {
        PsiClass outerClass = this.getOuterClass();
        PsiClass containingClass = descriptor.field.getContainingClass();
        String className = containingClass == null ? null : ClassUtil.getJVMClassName((PsiClass)containingClass);
        String fieldName = descriptor.field.getName();
        if (className == null || fieldName == null) {
            LOG.warn("Code is incomplete. Class name or field name not found");
            return null;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, "accessToField" + StringUtil.capitalize((String)fieldName));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        if (FieldAccessType.GET.equals((Object)accessType)) {
            String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)descriptor.expression, FieldReflectionAccessor.resolveFieldType(descriptor));
            if (returnType == null) {
                LOG.warn("Could not resolve field type");
                return null;
            }
            methodBuilder.accessedField(className, fieldName).setReturnType(returnType);
        } else {
            methodBuilder.updatedField(className, fieldName).setReturnType("void");
        }
        methodBuilder.setStatic(outerClass.hasModifierProperty("static")).addParameter("java.lang.Object", "object").addParameter("java.lang.Object", "value");
        return methodBuilder.build(this.getElementFactory(), (PsiElement)outerClass);
    }

    private static boolean needReplace(@NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
        return !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)field) || !PsiReflectionAccessUtil.isQualifierAccessible(expression2.getQualifierExpression());
    }

    @NotNull
    private static PsiType resolveFieldType(@NotNull FieldDescriptor descriptor) {
        PsiType rawType = descriptor.field.getType();
        return descriptor.expression.advancedResolve(false).getSubstitutor().substitute(rawType);
    }

    @Nullable
    private static String qualify(@NotNull FieldDescriptor descriptor) {
        PsiClass containingClass;
        String qualifier = PsiReflectionAccessUtil.extractQualifier(descriptor.expression);
        if (qualifier == null && !descriptor.field.hasModifierProperty("static") && (containingClass = descriptor.field.getContainingClass()) != null) {
            qualifier = containingClass.getQualifiedName() + ".this";
        }
        return qualifier;
    }

    public static class FieldDescriptor
    implements ItemToReplaceDescriptor {
        public final PsiField field;
        public final PsiReferenceExpression expression;

        public FieldDescriptor(@NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
            this.field = field;
            this.expression = expression2;
        }
    }
}

