/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ConstructorReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodReflectionAccessor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReferenceReflectionAccessorBase;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceReflectionAccessor
extends ReferenceReflectionAccessorBase<MethodReferenceDescriptor> {
    private static final Logger LOG = Logger.getInstance(MethodReferenceReflectionAccessor.class);
    private final MethodReflectionAccessor myMethodAccessor;
    private final ConstructorReflectionAccessor myConstructorReflectionAccessor;

    public MethodReferenceReflectionAccessor(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        super(psiClass, elementFactory);
        this.myMethodAccessor = new MethodReflectionAccessor(psiClass, elementFactory);
        this.myConstructorReflectionAccessor = new ConstructorReflectionAccessor(psiClass, elementFactory);
    }

    @Override
    @Nullable
    protected MethodReferenceDescriptor createDescriptor(@NotNull PsiReferenceExpression expression2) {
        PsiMethod method;
        PsiElement resolvedElement;
        if (expression2 instanceof PsiMethodReferenceExpression && (resolvedElement = expression2.resolve()) instanceof PsiMethod && !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)(method = (PsiMethod)resolvedElement))) {
            return new MethodReferenceDescriptor(method, (PsiMethodReferenceExpression)expression2);
        }
        return null;
    }

    @Override
    protected void grantAccess(@NotNull MethodReferenceDescriptor descriptor) {
        PsiElement lambdaBody;
        PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(descriptor.expression, false, true);
        PsiElement psiElement = lambdaBody = lambda2 == null ? null : lambda2.getBody();
        if (lambdaBody != null) {
            if (lambdaBody instanceof PsiNewExpression) {
                ConstructorReflectionAccessor.ConstructorDescriptor constructorDescriptor = ConstructorReflectionAccessor.ConstructorDescriptor.createIfInaccessible((PsiNewExpression)lambdaBody);
                if (constructorDescriptor != null) {
                    this.myConstructorReflectionAccessor.grantAccess(constructorDescriptor);
                } else {
                    LOG.warn("Inaccessible constructor not found. Method reference: " + descriptor.expression.getText());
                }
            } else if (lambdaBody instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lambdaBody;
                PsiMethod method = callExpression.resolveMethod();
                if (method != null) {
                    this.myMethodAccessor.grantAccess(new MethodReflectionAccessor.MethodCallDescriptor(callExpression, method));
                } else {
                    LOG.warn("Could not resolve method from expression: " + callExpression.getText());
                }
            } else {
                LOG.warn("Unexpected type of lambda body: " + lambdaBody.getClass().getCanonicalName());
            }
        } else {
            LOG.warn("Could not replace method reference with lambda: " + descriptor.expression.getText());
        }
    }

    public static class MethodReferenceDescriptor
    implements ItemToReplaceDescriptor {
        public final PsiMethod method;
        public final PsiMethodReferenceExpression expression;

        public MethodReferenceDescriptor(@NotNull PsiMethod method, @NotNull PsiMethodReferenceExpression expression2) {
            this.method = method;
            this.expression = expression2;
        }
    }
}

