/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessorBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReflectionAccessor
extends ReflectionAccessorBase<MethodCallDescriptor> {
    private static final Logger LOG = Logger.getInstance(MethodReflectionAccessor.class);

    protected MethodReflectionAccessor(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        super(psiClass, elementFactory);
    }

    @Override
    protected List<MethodCallDescriptor> findItemsToReplace(@NotNull PsiElement element) {
        final ArrayList<MethodCallDescriptor> result = new ArrayList<MethodCallDescriptor>();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiMethod method = expression2.resolveMethod();
                if (method != null && !Objects.equals(method.getContainingClass(), MethodReflectionAccessor.this.getOuterClass()) && MethodReflectionAccessor.needReplace(method, expression2.getMethodExpression())) {
                    result.add(new MethodCallDescriptor(expression2, method));
                }
            }
        });
        return result;
    }

    @Override
    protected void grantAccess(@NotNull MethodCallDescriptor descriptor) {
        PsiClass outerClass = this.getOuterClass();
        String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)descriptor.callExpression, MethodReflectionAccessor.resolveMethodReturnType(descriptor));
        PsiClass containingClass = descriptor.method.getContainingClass();
        String containingClassName = containingClass == null ? null : ClassUtil.getJVMClassName((PsiClass)containingClass);
        String name = descriptor.method.getName();
        if (returnType == null) {
            LOG.warn("return type of" + descriptor.method.getName() + " method is null");
            return;
        }
        if (containingClassName == null) {
            LOG.warn("containing class for method \"" + name + "\" not found");
            return;
        }
        String newMethodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, "call" + StringUtil.capitalize((String)name));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(newMethodName);
        PsiMethod newMethod = methodBuilder.accessedMethod(containingClassName, descriptor.method.getName()).setStatic(outerClass.hasModifierProperty("static")).addParameter("java.lang.Object", "object").addParameters(descriptor.method.getParameterList()).setReturnType(returnType).build(this.getElementFactory(), (PsiElement)this.getOuterClass());
        outerClass.add((PsiElement)newMethod);
        String qualifier = MethodReflectionAccessor.qualify(descriptor);
        String args = StreamEx.of((Object[])descriptor.callExpression.getArgumentList().getExpressions()).map(x -> x.getText()).prepend((Object)(qualifier == null ? "null" : qualifier)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String newMethodCallExpression = newMethod.getName() + args;
        descriptor.callExpression.replace((PsiElement)this.getElementFactory().createExpressionFromText(newMethodCallExpression, (PsiElement)descriptor.callExpression));
    }

    private static boolean needReplace(@NotNull PsiMethod method, @NotNull PsiReferenceExpression referenceExpression) {
        return !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)method) || !PsiReflectionAccessUtil.isQualifierAccessible(referenceExpression.getQualifierExpression());
    }

    @Nullable
    private static PsiType resolveMethodReturnType(@NotNull MethodCallDescriptor descriptor) {
        PsiSubstitutor substitutor = descriptor.callExpression.resolveMethodGenerics().getSubstitutor();
        return substitutor.substitute(descriptor.method.getReturnType());
    }

    @Nullable
    private static String qualify(@NotNull MethodCallDescriptor descriptor) {
        PsiClass containingClass;
        String qualifier = PsiReflectionAccessUtil.extractQualifier(descriptor.callExpression.getMethodExpression());
        if (qualifier == null && !descriptor.method.hasModifierProperty("static") && (containingClass = descriptor.method.getContainingClass()) != null) {
            qualifier = containingClass.getQualifiedName() + ".this";
        }
        return qualifier;
    }

    public static class MethodCallDescriptor
    implements ItemToReplaceDescriptor {
        public final PsiMethodCallExpression callExpression;
        public final PsiMethod method;

        public MethodCallDescriptor(@NotNull PsiMethodCallExpression expression2, @NotNull PsiMethod method) {
            this.callExpression = expression2;
            this.method = method;
        }
    }
}

