/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ReflectionAccessorBase<T extends ItemToReplaceDescriptor>
implements ReflectionAccessor {
    private final PsiClass myPsiClass;
    private final PsiElementFactory myElementFactory;
    private final Logger log = Logger.getInstance(this.getClass());

    protected ReflectionAccessorBase(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        this.myPsiClass = psiClass;
        this.myElementFactory = elementFactory;
    }

    @Override
    public void accessThroughReflection(@NotNull PsiElement element) {
        List<T> toReplace = this.findItemsToReplace(element);
        if (!toReplace.isEmpty()) {
            this.log.info("Found " + toReplace.size() + " items to replace");
        }
        for (ItemToReplaceDescriptor item : toReplace) {
            this.grantAccess(item);
        }
        List<T> remaining = this.findItemsToReplace(element);
        if (!remaining.isEmpty()) {
            this.log.warn("Some inaccessible items were not replaced");
        }
    }

    @NotNull
    protected PsiElementFactory getElementFactory() {
        return this.myElementFactory;
    }

    @NotNull
    protected PsiClass getOuterClass() {
        return this.myPsiClass;
    }

    protected abstract List<T> findItemsToReplace(@NotNull PsiElement var1);

    protected abstract void grantAccess(@NotNull T var1);
}

