/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineSuperClassRefactoringDialog
extends InlineOptionsDialog {
    private final PsiClass mySuperClass;
    private final PsiClass myCurrentInheritor;
    private final DocCommentPanel myDocPanel;

    protected InlineSuperClassRefactoringDialog(@NotNull Project project, PsiClass superClass, PsiClass currentInheritor) {
        super(project, false, (PsiElement)superClass);
        this.mySuperClass = superClass;
        this.myCurrentInheritor = currentInheritor;
        this.myInvokedOnReference = currentInheritor != null;
        this.myDocPanel = new DocCommentPanel("JavaDoc for inlined members");
        this.myDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        this.init();
        this.setTitle("Inline Super Class");
    }

    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_SUPER_CLASS_THIS = this.isInlineThisOnly();
        }
        this.invokeRefactoring((BaseRefactoringProcessor)new InlineSuperClassRefactoringProcessor(this.getProject(), this.isInlineThisOnly() ? this.myCurrentInheritor : null, this.mySuperClass, this.myDocPanel.getPolicy()));
    }

    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return "Inline_Super_Class";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        panel.add((Component)super.createCenterPanel(), gc);
        panel.add((Component)this.myDocPanel, gc);
        if (this.mySuperClass.getDocComment() == null) {
            boolean hasJavadoc = InlineSuperClassRefactoringProcessor.getClassMembersToPush(this.mySuperClass).stream().anyMatch(memberInfo -> {
                PsiMember member = (PsiMember)memberInfo.getMember();
                return member instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)member).getDocComment() != null;
            });
            this.myDocPanel.setVisible(hasJavadoc);
        }
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add(Box.createVerticalGlue(), gc);
        return panel;
    }

    protected String getNameLabelText() {
        return "Class " + this.mySuperClass.getQualifiedName();
    }

    protected String getBorderTitle() {
        return "Inline";
    }

    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.super.class");
    }

    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.super.class");
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_SUPER_CLASS_THIS;
    }
}

