/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPushDown.PushDownDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPushDownHandler
implements RefactoringActionHandler,
ElementsHandler,
ContextAwareActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"push.members.down.title");

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        return !JavaPushDownHandler.getElements(editor, file, (Ref<String>)Ref.create()).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        Ref errorMessage = Ref.create();
        List<PsiElement> elements = JavaPushDownHandler.getElements(editor, file, (Ref<String>)errorMessage);
        if (elements.isEmpty()) {
            String message2 = !errorMessage.isNull() ? (String)errorMessage.get() : RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.pushMembersDown");
        } else {
            this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
        }
    }

    @NotNull
    private static List<PsiElement> getElements(Editor editor, PsiFile file, Ref<String> errorMessage) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int offset = caret.getOffset();
            PsiElement element = file.findElementAt(offset);
            String errorFromElement = JavaPushDownHandler.collectElementsUnderCaret(element, elements);
            if (errorFromElement == null) continue;
            errorMessage.set((Object)errorFromElement);
        }
        return elements;
    }

    private static String collectElementsUnderCaret(PsiElement element, List<PsiElement> elements) {
        while (element != null && !(element instanceof PsiFile)) {
            if (element instanceof PsiClass && ((PsiClass)element).getQualifiedName() != null || element instanceof PsiField || element instanceof PsiMethod) {
                if (element instanceof JspClass) {
                    return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"refactoring.is.not.supported.for.jsp.classes"));
                }
                elements.add(element);
                return null;
            }
            element = element.getParent();
        }
        return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from"));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor;
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement[])elements), PsiClass.class, (boolean)false);
        if (aClass == null) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass.hasModifierProperty("final")) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactoringBundle.message((String)"refactoring.cannot.be.performed") + ": Class " + aClass.getName() + " is final"), (String)REFACTORING_NAME, (String)"refactoring.pushMembersDown");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(aClass, (MemberInfoBase.Filter<PsiMember>)((MemberInfoBase.Filter)element -> !(element instanceof PsiEnumConstant)));
        List members = memberInfoStorage.getClassMemberInfos((PsiElement)aClass);
        block0: for (MemberInfoBase member : members) {
            for (PsiElement element2 : elements) {
                if (!PsiTreeUtil.isAncestor((PsiElement)member.getMember(), (PsiElement)element2, (boolean)false)) continue;
                member.setChecked(true);
                continue block0;
            }
        }
        PushDownDialog dialog = new PushDownDialog(project, members.toArray(new MemberInfo[0]), aClass);
        dialog.show();
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }
}

