/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiPackageProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiDirectoryProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PsiDirectory;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameWithOptionalReferencesDialog(project, element, nameSuggestionContext, editor){

            protected boolean getSearchForReferences() {
                return RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
            }

            protected void setSearchForReferences(boolean value2) {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value2;
            }
        };
    }

    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (psiPackage != null) {
            return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(psiPackage, newName, nonJava);
        }
        return newName;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (!RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY) {
            return Collections.emptyList();
        }
        return ReferencesSearch.search((PsiElement)element).findAll();
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (aPackage != null) {
            return aPackage;
        }
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameDirectory";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        if (element != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }
}

