/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.rename.RenameHandler;
import org.jetbrains.annotations.NotNull;

public class RenameWrongRefHandler
implements RenameHandler {
    public final boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (editor == null || file == null || project == null) {
            return false;
        }
        return RenameWrongRefHandler.isAvailable(project, editor, file);
    }

    public static boolean isAvailable(Project project, Editor editor, PsiFile file) {
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        return reference instanceof PsiReferenceExpression && new RenameWrongRefFix((PsiReferenceExpression)reference, true).isAvailable(project, editor, file);
    }

    public final boolean isRenaming(@NotNull DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        if (reference instanceof PsiReferenceExpression) {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> new RenameWrongRefFix((PsiReferenceExpression)reference).invoke(project, editor, file));
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
    }
}

