/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(@NotNull PsiMethod method, String newName) {
        for (PsiMethod overload : this.getOverloads(method)) {
            if (overload == method || overload.findDeepestSuperMethods().length != 0) continue;
            this.myElements.add(overload);
            this.suggestAllNames(overload.getName(), newName);
        }
    }

    public String getDialogTitle() {
        return "Rename Overloads";
    }

    public String getDialogDescription() {
        return "Rename overloads to:";
    }

    public String entityName() {
        return "Overload";
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    @NotNull
    protected PsiMethod[] getOverloads(@NotNull PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        return containingClass.findMethodsByName(method.getName(), false);
    }
}

