/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AutomaticTestRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        return element instanceof PsiClass && !(element instanceof PsiTypeParameter) && TestFrameworks.detectFramework((PsiClass)((PsiClass)element)) == null;
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.tests");
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isToRenameTests();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameTests(enabled);
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new TestsRenamer((PsiClass)element, newName);
    }

    private static class TestsRenamer
    extends AutomaticRenamer {
        TestsRenamer(PsiClass aClass, String newClassName) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module != null) {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
                PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)aClass.getProject());
                Pattern pattern = Pattern.compile(".*" + aClass.getName() + ".*");
                int count = 0;
                for (String eachName : ContainerUtil.newHashSet((Object[])cache.getAllClassNames())) {
                    if (!pattern.matcher(eachName).matches()) continue;
                    if (count++ > 1000) break;
                    for (PsiClass eachClass : cache.getClassesByName(eachName, moduleScope)) {
                        if (TestFrameworks.detectFramework((PsiClass)eachClass) == null) continue;
                        this.myElements.add(eachClass);
                    }
                }
                this.suggestAllNames(aClass.getName(), newClassName);
            }
        }

        public String getDialogTitle() {
            return RefactoringBundle.message((String)"rename.tests.title");
        }

        public String getDialogDescription() {
            return RefactoringBundle.message((String)"rename.tests.with.the.following.names.to");
        }

        public String entityName() {
            return RefactoringBundle.message((String)"entity.name.test");
        }
    }
}

