/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usages.RenameableUsage;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AutomaticUsageRenamer<T> {
    private final String myOldName;
    private final String myNewName;
    private final Map<T, String> myRenames = new LinkedHashMap<T, String>();
    private final List<T> myElements = new ArrayList<T>();
    private final Map<T, List<RenameableUsage>> myReferences = new HashMap<T, List<RenameableUsage>>();

    protected AutomaticUsageRenamer(List<? extends T> renamedElements, String oldName, String newName) {
        this.myOldName = oldName;
        this.myNewName = newName;
        ArrayList<T> elements = new ArrayList<T>(renamedElements);
        Collections.sort(elements, (o1, o2) -> {
            int i = StringUtil.compare((String)this.getSourceName(o1), (String)this.getSourceName(o2), (boolean)false);
            if (i != 0) {
                return i;
            }
            return this.getName(o1).compareTo(this.getName(o2));
        });
        for (Object element : elements) {
            String suggestedNewName = this.suggestName(element);
            if (this.getName(element).equals(suggestedNewName)) continue;
            this.myElements.add(element);
            this.setRename(element, suggestedNewName);
        }
    }

    public boolean hasAnythingToRename() {
        for (String s : this.myRenames.values()) {
            if (s == null) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.myRenames.isEmpty();
    }

    protected String getOldName() {
        return this.myOldName;
    }

    public String getNewName() {
        return this.myNewName;
    }

    protected boolean isChecked(T element) {
        return this.myRenames.containsKey(element);
    }

    protected boolean isCheckedInitially(T element) {
        return false;
    }

    protected boolean isNameAlreadySuggested(String newName) {
        return this.myRenames.values().contains(newName);
    }

    public List<? extends T> getElements() {
        return this.myElements;
    }

    @Nullable
    public String getSourceName(T element) {
        return null;
    }

    public String getNewElementName(T element) {
        return this.myRenames.get(element);
    }

    public Map<? extends T, String> getRenames() {
        return this.myRenames;
    }

    public void setRename(T element, @NotNull String replacement) {
        this.myRenames.put(element, replacement);
    }

    public void doNotRename(T element) {
        this.myRenames.remove(element);
    }

    @Nullable
    public String getErrorText(T element) {
        return null;
    }

    public final void doRename() throws IncorrectOperationException {
        for (Map.Entry<T, List<RenameableUsage>> entry : this.myReferences.entrySet()) {
            T element = entry.getKey();
            String newName = this.getNewElementName(element);
            this.doRenameElement(element);
            for (RenameableUsage usage : entry.getValue()) {
                usage.rename(newName);
            }
        }
    }

    protected abstract void doRenameElement(T var1) throws IncorrectOperationException;

    protected abstract String suggestName(T var1);

    protected abstract String getName(T var1);

    public abstract String getDialogTitle();

    public abstract String getDialogDescription();

    public abstract String getEntityName();
}

