/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import org.jetbrains.annotations.NotNull;

class RefsToSuperViewDescriptor
implements UsageViewDescriptor {
    private final PsiClass myClass;
    private final PsiClass mySuper;

    RefsToSuperViewDescriptor(PsiClass aClass, PsiClass anInterface) {
        this.myClass = aClass;
        this.mySuper = anInterface;
    }

    @NotNull
    public PsiElement[] getElements() {
        return new PsiElement[]{this.myClass, this.mySuper};
    }

    public String getProcessedElementsHeader() {
        return null;
    }

    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(RefactoringBundle.message((String)"references.to.0.to.be.replaced.with.references.to.1", (Object[])new Object[]{this.myClass.getName(), this.mySuper.getName()}));
        buffer.append(" ");
        buffer.append(UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
        return buffer.toString();
    }

    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return null;
    }
}

