/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.TypeCookViewDescriptor;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.builder.Result;
import com.intellij.refactoring.typeCook.deductive.builder.SystemBuilder;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import com.intellij.refactoring.typeCook.deductive.resolver.ResolverTree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeCookProcessor
extends BaseRefactoringProcessor {
    private PsiElement[] myElements;
    private final Settings mySettings;
    private Result myResult;

    public TypeCookProcessor(Project project, PsiElement[] elements, Settings settings) {
        super(project);
        this.myElements = elements;
        this.mySettings = settings;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new TypeCookViewDescriptor(this.myElements);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ReductionSystem[] systems;
        SystemBuilder systemBuilder = new SystemBuilder(this.myProject, this.mySettings);
        ReductionSystem commonSystem = systemBuilder.build(this.myElements);
        this.myResult = new Result(commonSystem);
        for (ReductionSystem system : systems = commonSystem.isolate()) {
            if (system == null) continue;
            ResolverTree tree = new ResolverTree(system);
            tree.resolve();
            Binding solution = tree.getBestSolution();
            if (solution == null) continue;
            this.myResult.incorporateSolution(solution);
        }
        Set<PsiElement> changedItems = this.myResult.getCookedElements();
        UsageInfo[] usages = new UsageInfo[changedItems.size()];
        int i = 0;
        for (final PsiElement element : changedItems) {
            if (!(element instanceof PsiTypeCastExpression)) {
                usages[i++] = new UsageInfo(element){

                    public String getTooltipText() {
                        return TypeCookProcessor.this.myResult.getCookedType(element).getCanonicalText();
                    }
                };
                continue;
            }
            usages[i++] = new UsageInfo(element);
        }
        return usages;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        this.myElements = elements;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        HashSet<PsiElement> victims = new HashSet<PsiElement>();
        for (UsageInfo usage : usages) {
            victims.add(usage.getElement());
        }
        this.myResult.apply(victims);
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo(this.myResult.getReport());
    }

    protected boolean isGlobalUndoAction() {
        return true;
    }

    @NotNull
    protected String getCommandName() {
        return RefactoringBundle.message((String)"type.cook.command");
    }

    public List<PsiElement> getElements() {
        return ContainerUtil.immutableList((Object[])this.myElements);
    }
}

