/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeSignatureHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(ChangeTypeSignatureHandler.class);
    public static final String REFACTORING_NAME = "Type Migration";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
        PsiElement element = file.findElementAt(offset);
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
        while (typeElement != null) {
            PsiElement parent = typeElement.getParent();
            PsiElement[] toMigrate = null;
            if (parent instanceof PsiVariable) {
                toMigrate = ChangeTypeSignatureHandler.extractReferencedVariables(typeElement);
            } else if (parent instanceof PsiMember && !(parent instanceof PsiClass) || ChangeTypeSignatureHandler.isClassArgument(parent)) {
                toMigrate = new PsiElement[]{parent};
            }
            if (toMigrate != null && toMigrate.length > 0) {
                ChangeTypeSignatureHandler.invoke(project, toMigrate, editor);
                return;
            }
            typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiTypeElement.class, (boolean)false);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"The caret should be positioned on type of field, variable, method or method parameter to be refactored", (String)REFACTORING_NAME, (String)"refactoring.migrateType");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        LOG.assertTrue(elements.length == 1);
        PsiElement element = elements[0];
        ChangeTypeSignatureHandler.invokeOnElement(project, element);
    }

    private static void invokeOnElement(Project project, PsiElement element) {
        if (element instanceof PsiVariable || element instanceof PsiMember && !(element instanceof PsiClass) || element instanceof PsiFile || ChangeTypeSignatureHandler.isClassArgument(element)) {
            ChangeTypeSignatureHandler.invoke(project, new PsiElement[]{element}, null);
        }
    }

    private static boolean isClassArgument(PsiElement element) {
        if (element instanceof PsiReferenceParameterList) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            if (member instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == element;
            }
            if (member instanceof PsiClass) {
                PsiReferenceList implementsList = ((PsiClass)member).getImplementsList();
                PsiReferenceList extendsList = ((PsiClass)member).getExtendsList();
                return PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false);
            }
        }
        return false;
    }

    private static void invoke(@NotNull Project project, @NotNull PsiElement[] roots, @Nullable Editor editor) {
        if (Util.canBeMigrated(roots)) {
            TypeMigrationDialog.SingleElement dialog = new TypeMigrationDialog.SingleElement(project, roots);
            dialog.show();
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"only.fields.variables.of.methods.of.valid.type.can.be.considered"), (String)RefactoringBundle.message((String)"unable.to.start.type.migration"), null);
    }

    @NotNull
    private static PsiElement[] extractReferencedVariables(@NotNull PsiTypeElement typeElement) {
        PsiElement parent = typeElement.getParent();
        if (parent instanceof PsiVariable) {
            PsiDeclarationStatement declaration2;
            if (parent instanceof PsiField) {
                PsiField aField = (PsiField)parent;
                ArrayList<PsiField> fields = new ArrayList<PsiField>();
                do {
                    fields.add(aField);
                } while ((aField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)aField, PsiField.class)) != null && aField.getTypeElement() == typeElement);
                return fields.toArray(PsiElement.EMPTY_ARRAY);
            }
            if (parent instanceof PsiLocalVariable && (declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDeclarationStatement.class)) != null) {
                return (PsiElement[])Arrays.stream(declaration2.getDeclaredElements()).filter(PsiVariable.class::isInstance).toArray(PsiVariable[]::new);
            }
            return new PsiElement[]{parent};
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

