/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.util.classMembers.ClassThisReferencesVisitor;

public class ElementNeedsThis
extends ClassThisReferencesVisitor {
    private boolean myResult;
    private final PsiElement myMember;

    public ElementNeedsThis(PsiClass aClass, PsiElement member) {
        super(aClass);
        this.myMember = member;
    }

    public ElementNeedsThis(PsiClass aClass) {
        super(aClass);
        this.myMember = null;
    }

    public boolean usesMembers() {
        return this.myResult;
    }

    @Override
    protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
        if (classMember == null || classMember.equals(this.myMember)) {
            return;
        }
        if (classMember.hasModifierProperty("static")) {
            return;
        }
        if (this.ignoreUsedTypeParams() && classMember instanceof PsiTypeParameter) {
            return;
        }
        this.myResult = true;
    }

    protected boolean ignoreUsedTypeParams() {
        return this.myMember != null;
    }

    @Override
    protected void visitExplicitThis(PsiClass referencedClass, PsiThisExpression reference) {
        this.myResult = true;
    }

    @Override
    protected void visitExplicitSuper(PsiClass referencedClass, PsiSuperExpression reference) {
        this.myResult = true;
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        super.visitReferenceExpression(expression2);
        PsiType type2 = expression2.getType();
        if (type2 != null) {
            PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
            type2.accept((PsiTypeVisitor)searcher);
            for (PsiTypeParameter parameter2 : searcher.getTypeParameters()) {
                PsiTypeParameterListOwner owner = parameter2.getOwner();
                if (!(owner instanceof PsiClass) || !this.myClassSuperClasses.contains(owner)) continue;
                this.myResult = true;
                break;
            }
        }
    }

    public void visitElement(PsiElement element) {
        if (this.myResult) {
            return;
        }
        super.visitElement(element);
    }
}

