/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.DuplicatesImpl");

    private DuplicatesImpl() {
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull MatchProvider provider) {
        DuplicatesImpl.invoke(project, editor, provider, true);
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull MatchProvider provider, boolean skipPromptWhenOne) {
        List<Match> duplicates = provider.getDuplicates();
        int idx = 0;
        Ref showAll = new Ref();
        String confirmDuplicatePrompt = DuplicatesImpl.getConfirmationPrompt(provider, duplicates);
        for (Match match : duplicates) {
            if (!match.getMatchStart().isValid() || !match.getMatchEnd().isValid() || !DuplicatesImpl.replaceMatch(project, provider, match, editor, ++idx, duplicates.size(), (Ref<Boolean>)showAll, confirmDuplicatePrompt, skipPromptWhenOne)) continue;
            return;
        }
    }

    public static void invoke(Project project, MatchProvider provider, boolean showDialog) {
        List<Match> duplicates = provider.getDuplicates();
        int idx = 0;
        Ref showAll = new Ref();
        if (!showDialog) {
            showAll.set((Object)true);
        }
        String confirmDuplicatePrompt = DuplicatesImpl.getConfirmationPrompt(provider, duplicates);
        for (Match match : duplicates) {
            PsiFile file = match.getFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), false);
            LOG.assertTrue(editor != null);
            if (!match.getMatchStart().isValid() || !match.getMatchEnd().isValid() || !DuplicatesImpl.replaceMatch(project, provider, match, editor, ++idx, duplicates.size(), (Ref<Boolean>)showAll, confirmDuplicatePrompt, false)) continue;
            return;
        }
    }

    @Nullable
    private static String getConfirmationPrompt(MatchProvider provider, List<Match> duplicates) {
        Match duplicate;
        String confirmDuplicatePrompt = null;
        Iterator<Match> iterator = duplicates.iterator();
        while (iterator.hasNext() && (confirmDuplicatePrompt = provider.getConfirmDuplicatePrompt(duplicate = iterator.next())) == null) {
        }
        return confirmDuplicatePrompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean replaceMatch(Project project, MatchProvider provider, Match match, @NotNull Editor editor, int idx, int size, Ref<Boolean> showAll, String confirmDuplicatePrompt, boolean skipPromptWhenOne) {
        ArrayList<RangeHighlighter> highlighters = DuplicatesImpl.previewMatch(project, match, editor);
        try {
            if (!(ApplicationManager.getApplication().isUnitTestMode() || skipPromptWhenOne && size <= 1 || showAll.get() != null && ((Boolean)showAll.get()).booleanValue())) {
                final String prompt = provider.getConfirmDuplicatePrompt(match);
                ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, provider.getReplaceDuplicatesTitle(idx, size), project){

                    protected String getMessage() {
                        String message2 = super.getMessage();
                        return prompt != null ? message2 + " " + prompt : message2;
                    }
                };
                promptDialog.show();
                boolean allChosen = promptDialog.getExitCode() == 3;
                showAll.set((Object)allChosen);
                if (allChosen && confirmDuplicatePrompt != null && prompt == null && Messages.showOkCancelDialog((Project)project, (String)"In order to replace all occurrences method signature will be changed. Proceed?", (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) != 0) {
                    boolean bl = true;
                    return bl;
                }
                if (promptDialog.getExitCode() == 2) {
                    boolean bl = false;
                    return bl;
                }
                if (promptDialog.getExitCode() == 1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighters.get(0));
        }
        provider.prepareSignature(match);
        WriteCommandAction.writeCommandAction((Project)project).withName(MethodDuplicatesHandler.REFACTORING_NAME).withGroupId(MethodDuplicatesHandler.REFACTORING_NAME).run(() -> {
            try {
                provider.processMatch(match);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
        return false;
    }

    public static ArrayList<RangeHighlighter> previewMatch(Project project, Match match, Editor editor) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        DuplicatesImpl.highlightMatch(project, editor, match, highlighters);
        TextRange textRange = match.getTextRange();
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
        DuplicatesImpl.expandAllRegionsCoveringRange(project, editor, textRange);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
        return highlighters;
    }

    private static void expandAllRegionsCoveringRange(Project project, Editor editor, TextRange textRange) {
        FoldRegion[] foldRegions = CodeFoldingManager.getInstance((Project)project).getFoldRegionsAtOffset(editor, textRange.getStartOffset());
        boolean anyCollapsed = false;
        for (FoldRegion foldRegion : foldRegions) {
            if (foldRegion.isExpanded()) continue;
            anyCollapsed = true;
            break;
        }
        if (anyCollapsed) {
            editor.getFoldingModel().runBatchFoldingOperation(() -> {
                for (FoldRegion foldRegion : foldRegions) {
                    if (foldRegion.isExpanded()) continue;
                    foldRegion.setExpanded(true);
                }
            });
        }
    }

    public static void highlightMatch(Project project, Editor editor, Match match, ArrayList<RangeHighlighter> highlighters) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, match.getTextRange().getStartOffset(), match.getTextRange().getEndOffset(), attributes, true, highlighters);
    }

    public static void processDuplicates(@NotNull MatchProvider provider, @NotNull Project project, @NotNull Editor editor) {
        Boolean hasDuplicates = provider.hasDuplicates();
        if (hasDuplicates == null || hasDuplicates.booleanValue()) {
            int answer;
            List<Match> duplicates = provider.getDuplicates();
            ArrayList<RangeHighlighter> highlighters = null;
            if (duplicates.size() == 1) {
                highlighters = DuplicatesImpl.previewMatch(project, duplicates.get(0), editor);
            }
            int n = answer = ApplicationManager.getApplication().isUnitTestMode() || hasDuplicates == null ? 0 : Messages.showYesNoDialog((Project)project, (String)RefactoringBundle.message((String)"0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.method", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()}), (String)"Process Duplicates", (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                DuplicatesImpl.invoke(project, editor, provider, hasDuplicates != null);
            } else if (highlighters != null) {
                HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                for (RangeHighlighter highlighter : highlighters) {
                    highlightManager.removeSegmentHighlighter(editor, highlighter);
                }
            }
        }
    }
}

