/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ComplexityHolder;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractableExpressionPart {
    final PsiExpression myUsage;
    final PsiVariable myVariable;
    final Object myValue;
    final PsiType myType;

    private ExtractableExpressionPart(@NotNull PsiExpression usage, PsiVariable variable, Object value2, @NotNull PsiType type2) {
        this.myUsage = usage;
        this.myVariable = variable;
        this.myValue = value2;
        this.myType = type2;
    }

    @Nullable
    static PsiType commonType(@NotNull ExtractableExpressionPart part1, @NotNull ExtractableExpressionPart part2) {
        return ExtractableExpressionPart.commonType(part1.myType, part2.myType);
    }

    @Nullable
    private static PsiType commonType(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return null;
    }

    @NotNull
    ExtractableExpressionPart copy() {
        return new ExtractableExpressionPart(this.myUsage, this.myVariable, this.myValue, this.myType);
    }

    public boolean isEquivalent(@NotNull ExtractableExpressionPart part) {
        if (this.myVariable != null && this.myVariable.equals(part.myVariable)) {
            return true;
        }
        if (this.myValue != null && this.myValue.equals(part.myValue)) {
            return true;
        }
        PsiExpression usage1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myUsage);
        PsiExpression usage2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)part.myUsage);
        return usage1 != null && usage2 != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent(usage1, usage2);
    }

    @Nullable
    static ExtractableExpressionPart match(@NotNull PsiExpression expression2, @NotNull List<? extends PsiElement> scope, @Nullable ComplexityHolder complexityHolder) {
        if (expression2 instanceof PsiReferenceExpression) {
            return ExtractableExpressionPart.matchVariable((PsiReferenceExpression)expression2, scope);
        }
        boolean isConstant = PsiUtil.isConstantExpression((PsiExpression)expression2);
        if (isConstant && PsiTreeUtil.findChildOfType((PsiElement)expression2, PsiJavaCodeReferenceElement.class) == null) {
            return ExtractableExpressionPart.matchConstant(expression2);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
            return null;
        }
        if (complexityHolder != null && (isConstant || complexityHolder.isAcceptableExpression(expression2))) {
            return ExtractableExpressionPart.matchExpression(expression2);
        }
        return null;
    }

    @Nullable
    private static ExtractableExpressionPart matchConstant(@NotNull PsiExpression expression2) {
        PsiType type2;
        PsiConstantEvaluationHelper constantHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getConstantEvaluationHelper();
        Object value2 = constantHelper.computeConstantExpression((PsiElement)expression2, false);
        if (value2 != null && (type2 = expression2.getType()) != null) {
            return new ExtractableExpressionPart(expression2, null, value2, type2);
        }
        return null;
    }

    @Nullable
    static ExtractableExpressionPart matchVariable(@NotNull PsiReferenceExpression expression2, @Nullable List<? extends PsiElement> scope) {
        PsiElement resolved = expression2.resolve();
        if (resolved instanceof PsiField && ExtractableExpressionPart.isModification(expression2)) {
            return null;
        }
        if (resolved instanceof PsiVariable && (scope == null || !DuplicatesFinder.isUnder(resolved, scope))) {
            PsiVariable variable = (PsiVariable)resolved;
            return new ExtractableExpressionPart((PsiExpression)expression2, variable, null, variable.getType());
        }
        return null;
    }

    private static boolean isModification(@NotNull PsiReferenceExpression expression2) {
        PsiUnaryExpression unary;
        IElementType tokenType;
        PsiAssignmentExpression assignment;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        return parent instanceof PsiAssignmentExpression ? PsiTreeUtil.isAncestor((PsiElement)(assignment = (PsiAssignmentExpression)parent).getLExpression(), (PsiElement)expression2, (boolean)false) : parent instanceof PsiUnaryExpression && ((tokenType = (unary = (PsiUnaryExpression)parent).getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) && PsiTreeUtil.isAncestor((PsiElement)unary.getOperand(), (PsiElement)expression2, (boolean)false);
    }

    @Nullable
    private static ExtractableExpressionPart matchExpression(@NotNull PsiExpression expression2) {
        PsiType type2 = expression2.getType();
        if (type2 != null && !PsiType.VOID.equals((Object)type2)) {
            return new ExtractableExpressionPart(expression2, null, null, type2);
        }
        return null;
    }

    @NotNull
    public PsiExpression getUsage() {
        return this.myUsage;
    }

    @NotNull
    public static ExtractableExpressionPart fromUsage(@NotNull PsiExpression usage, @NotNull PsiType type2) {
        PsiType usageType;
        assert ((usageType = usage.getType()) == null || type2.isAssignableFrom(usageType)) : "expected " + type2.getCanonicalText() + ", got " + usageType.getCanonicalText();
        return new ExtractableExpressionPart(usage, null, null, type2);
    }

    public String toString() {
        return this.myUsage.getText();
    }
}

