/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class ExtractedParameter {
    @NotNull
    public final PsiType myType;
    @NotNull
    public final ExtractableExpressionPart myPattern;
    @NotNull
    public final ExtractableExpressionPart myCandidate;
    @NotNull
    public final Set<PsiExpression> myPatternUsages = new HashSet<PsiExpression>();

    public ExtractedParameter(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart, @NotNull PsiType type2) {
        this.myType = type2;
        this.myPattern = patternPart;
        this.myCandidate = candidatePart;
        this.addUsages(patternPart);
    }

    public static boolean match(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart, @NotNull List<ExtractedParameter> parameters2) {
        PsiType type2 = ExtractableExpressionPart.commonType(patternPart, candidatePart);
        if (type2 == null) {
            return false;
        }
        parameters2.add(new ExtractedParameter(patternPart, candidatePart, type2));
        return true;
    }

    @NotNull
    public ExtractedParameter copyWithCandidateUsage(@NotNull PsiExpression candidateUsage) {
        ExtractedParameter result = new ExtractedParameter(this.myPattern, ExtractableExpressionPart.fromUsage(candidateUsage, this.myType), this.myType);
        result.myPatternUsages.addAll(this.myPatternUsages);
        return result;
    }

    @NotNull
    public String getLocalVariableTypeText() {
        PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.myType);
        return type2.getCanonicalText();
    }

    public void addUsages(@NotNull ExtractableExpressionPart patternPart) {
        this.myPatternUsages.add(patternPart.getUsage());
    }

    public static List<Match> getCompatibleMatches(@NotNull List<Match> matches, @NotNull PsiElement[] pattern, @NotNull List<PsiElement[]> candidates) {
        ArrayList<Match> result = new ArrayList<Match>();
        Set firstUsages = null;
        for (Match match : matches) {
            List<ExtractedParameter> parameters2 = match.getExtractedParameters();
            PsiElement[] candidateElements = (PsiElement[])ContainerUtil.find(candidates, elements -> ((PsiElement[])elements).length != 0 && match.getMatchStart() == elements[0]);
            Set candidateVariables = ContainerUtil.map2SetNotNull(parameters2, parameter2 -> parameter2.myCandidate.myVariable);
            if (candidateElements == null || ExtractedParameter.containsModifiedField(candidateElements, candidateVariables)) continue;
            Set patternUsages = StreamEx.of(parameters2).map(p -> p.myPattern.getUsage()).toSet();
            if (firstUsages == null) {
                Set patternVariables = ContainerUtil.map2SetNotNull(parameters2, parameter2 -> parameter2.myPattern.myVariable);
                if (ExtractedParameter.containsModifiedField(pattern, patternVariables)) {
                    return Collections.emptyList();
                }
                firstUsages = patternUsages;
                result.add(match);
                continue;
            }
            if (!firstUsages.equals(patternUsages)) continue;
            result.add(match);
        }
        return result;
    }

    private static boolean containsModifiedField(@NotNull PsiElement[] elements, @NotNull Set<PsiVariable> variables) {
        Set fields = ((StreamEx)StreamEx.of(variables).select(PsiField.class).filter(field -> !field.hasModifierProperty("final"))).toSet();
        if (!fields.isEmpty()) {
            FieldModificationVisitor visitor = new FieldModificationVisitor(fields);
            for (PsiElement element : elements) {
                element.accept((PsiElementVisitor)visitor);
                if (!visitor.myModified) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.myPattern + " -> " + this.myCandidate + " [" + this.myPatternUsages.size() + "] : " + this.myType.getPresentableText();
    }

    private static class FieldModificationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myFields;
        private boolean myModified;

        FieldModificationVisitor(Set<PsiField> fields) {
            this.myFields = fields;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.visitModifiedExpression(expression2.getLExpression());
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            IElementType op = expression2.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression2.getOperand());
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            super.visitPostfixExpression(expression2);
            IElementType op = expression2.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression2.getOperand());
            }
        }

        private void visitModifiedExpression(PsiExpression modifiedExpression) {
            PsiField field;
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)modifiedExpression);
            if (expression2 instanceof PsiReferenceExpression && (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiField.class)) != null && this.myFields.contains(field)) {
                this.myModified = true;
                this.stopWalking();
            }
        }
    }
}

