/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class WrapReturnValue
extends FixableUsageInfo {
    private final PsiReturnStatement myStatement;
    private final String myType;

    public WrapReturnValue(@NotNull PsiReturnStatement statement, @NotNull String type2) {
        super((PsiElement)statement);
        this.myStatement = statement;
        this.myType = type2;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiExpression returnValue = this.myStatement.getReturnValue();
        assert (returnValue != null);
        String newExpression = "new " + this.myType + '(' + returnValue.getText() + ')';
        MutationUtils.replaceExpression(newExpression, returnValue);
    }
}

