/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.JavaSliceProvider;
import com.intellij.slicer.JavaSlicerAnalysisUtil;
import com.intellij.slicer.SliceNullnessAnalyzerBase;
import org.jetbrains.annotations.NotNull;

public class JavaSliceNullnessAnalyzer
extends SliceNullnessAnalyzerBase {
    public JavaSliceNullnessAnalyzer() {
        super(JavaSlicerAnalysisUtil.LEAF_ELEMENT_EQUALITY, JavaSliceProvider.getInstance());
    }

    @Override
    @NotNull
    protected Nullability checkNullability(PsiElement element) {
        Nullability result;
        PsiMethod method;
        PsiElement value2 = element;
        if (value2 instanceof PsiExpression) {
            value2 = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)value2));
        }
        if (value2 instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)value2).getValue() == null ? Nullability.NULLABLE : Nullability.NOT_NULL;
        }
        if (value2 instanceof PsiNewExpression) {
            return Nullability.NOT_NULL;
        }
        if (value2 instanceof PsiThisExpression) {
            return Nullability.NOT_NULL;
        }
        if (value2 instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)value2).resolveMethod()) != null) {
            return NullableNotNullManager.getNullability((PsiModifierListOwner)method);
        }
        if (value2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)value2).getOperationTokenType() == JavaTokenType.PLUS) {
            return Nullability.NOT_NULL;
        }
        PsiElement context = value2;
        if (value2 instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)value2).resolve();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            value2 = resolved;
        }
        if (value2 instanceof PsiParameter && ((PsiParameter)value2).getDeclarationScope() instanceof PsiCatchSection) {
            return Nullability.NOT_NULL;
        }
        if ((value2 instanceof PsiLocalVariable || value2 instanceof PsiParameter) && (result = DfaUtil.checkNullability((PsiVariable)value2, context)) != Nullability.UNKNOWN) {
            return result;
        }
        if (value2 instanceof PsiEnumConstant) {
            return Nullability.NOT_NULL;
        }
        if (value2 instanceof PsiModifierListOwner) {
            return NullableNotNullManager.getNullability((PsiModifierListOwner)((PsiModifierListOwner)value2));
        }
        return Nullability.UNKNOWN;
    }
}

