/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.CanItBeNullAction;
import com.intellij.slicer.GroupByLeavesAction;
import com.intellij.slicer.JavaSliceNullnessAnalyzer;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.JavaSlicerAnalysisUtil;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.slicer.SliceUsageTransformer;
import com.intellij.slicer.SliceUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSliceProvider
implements SliceLanguageSupportProvider,
SliceUsageTransformer {
    public static JavaSliceProvider getInstance() {
        return (JavaSliceProvider)LanguageSlicing.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    public SliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        return JavaSliceUsage.createRootUsage(element, params);
    }

    @Nullable
    public Collection<SliceUsage> transform(@NotNull SliceUsage usage) {
        if (usage instanceof JavaSliceUsage) {
            return null;
        }
        PsiElement element = usage.getElement();
        SliceUsage parent = usage.getParent();
        if (usage.params.dataFlowToThis && element instanceof PsiMethod) {
            return SliceUtil.collectMethodReturnValues(parent, parent instanceof JavaSliceUsage ? ((JavaSliceUsage)parent).getSubstitutor() : PsiSubstitutor.EMPTY, (PsiMethod)element);
        }
        if (!(element instanceof PsiExpression) && !(element instanceof PsiVariable)) {
            return null;
        }
        JavaSliceUsage newUsage = parent != null ? new JavaSliceUsage(element, parent, PsiSubstitutor.EMPTY, 0, "") : this.createRootUsage(element, usage.params);
        return Collections.singletonList(newUsage);
    }

    @Nullable
    public PsiElement getExpressionAtCaret(@NotNull PsiElement atCaret, boolean dataFlowToThis) {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{PsiExpression.class, PsiVariable.class, PsiMethod.class});
        if (dataFlowToThis && element instanceof PsiLiteralExpression) {
            return null;
        }
        return element;
    }

    @NotNull
    public PsiElement getElementForDescription(@NotNull PsiElement element) {
        PsiElement elementToSlice;
        if (element instanceof PsiReferenceExpression && (elementToSlice = ((PsiReferenceExpression)element).resolve()) != null) {
            return elementToSlice;
        }
        return element;
    }

    @NotNull
    public SliceUsageCellRendererBase getRenderer() {
        return new SliceUsageCellRenderer();
    }

    public void startAnalyzeLeafValues(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        JavaSlicerAnalysisUtil.createLeafAnalyzer().startAnalyzeValues(structure, finalRunnable);
    }

    public void startAnalyzeNullness(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        new JavaSliceNullnessAnalyzer().startAnalyzeNullness(structure, finalRunnable);
    }

    public void registerExtraPanelActions(@NotNull DefaultActionGroup actionGroup, @NotNull SliceTreeBuilder sliceTreeBuilder) {
        if (sliceTreeBuilder.dataFlowToThis) {
            actionGroup.add((AnAction)new GroupByLeavesAction(sliceTreeBuilder));
            actionGroup.add((AnAction)new CanItBeNullAction(sliceTreeBuilder));
        }
    }
}

