/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.JavaSliceDereferenceUsage;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SliceForwardUtil {
    SliceForwardUtil() {
    }

    static boolean processUsagesFlownFromThe(@NotNull PsiElement element, @NotNull JavaSliceUsage parent, @NotNull Processor<? super SliceUsage> processor) {
        PsiExpression expression2 = SliceForwardUtil.getMethodCallTarget(element);
        if (expression2 != null && !SliceUtil.createAndProcessSliceUsage((PsiElement)expression2, parent, parent.getSubstitutor(), parent.indexNesting, "", processor)) {
            return false;
        }
        Pair<PsiElement, PsiSubstitutor> pair = SliceForwardUtil.getAssignmentTarget(element, parent);
        if (pair != null) {
            PsiParameter parameter2;
            PsiElement declarationScope;
            PsiElement target = (PsiElement)pair.getFirst();
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.getSecond();
            if (target instanceof PsiParameter && (declarationScope = (parameter2 = (PsiParameter)target).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)declarationScope;
                int parameterIndex = method.getParameterList().getParameterIndex(parameter2);
                Processor myProcessor = override -> {
                    if (!parent.getScope().contains((PsiElement)override)) {
                        return true;
                    }
                    PsiSubstitutor superSubstitutor = method == override ? substitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)method.getSignature(substitutor), (MethodSignature)override.getSignature(substitutor));
                    PsiParameter[] parameters2 = override.getParameterList().getParameters();
                    if (parameters2.length <= parameterIndex) {
                        return true;
                    }
                    PsiParameter actualParam = parameters2[parameterIndex];
                    return SliceUtil.createAndProcessSliceUsage((PsiElement)actualParam, parent, superSubstitutor, parent.indexNesting, "", processor);
                };
                if (!myProcessor.process((Object)method)) {
                    return false;
                }
                return OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(myProcessor);
            }
            return SliceUtil.createAndProcessSliceUsage(target, parent, parent.getSubstitutor(), parent.indexNesting, "", processor);
        }
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            PsiVariable variable = (PsiVariable)resolved;
            return SliceForwardUtil.processAssignedFrom((PsiElement)variable, (PsiElement)ref, parent, processor);
        }
        if (element instanceof PsiVariable) {
            return SliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        if (element instanceof PsiMethod) {
            return SliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        return true;
    }

    private static boolean processAssignedFrom(@NotNull PsiElement from, @NotNull PsiElement context, @NotNull JavaSliceUsage parent, @NotNull Processor<? super SliceUsage> processor) {
        if (from instanceof PsiLocalVariable) {
            return SliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, context, parent, processor);
        }
        if (from instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)from;
            PsiElement scope = parameter2.getDeclarationScope();
            THashSet parametersToAnalyze = new THashSet();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                int index = method.getParameterList().getParameterIndex(parameter2);
                THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
                superMethods.add(method);
                Iterator iterator = superMethods.iterator();
                while (iterator.hasNext()) {
                    ProgressManager.checkCanceled();
                    PsiMethod superMethod = (PsiMethod)iterator.next();
                    if (parent.params.scope.contains((PsiElement)superMethod)) continue;
                    iterator.remove();
                }
                THashSet implementors = new THashSet((Collection)superMethods);
                for (PsiMethod superMethod : superMethods) {
                    ProgressManager.checkCanceled();
                    if (OverridingMethodsSearch.search((PsiMethod)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(sub -> {
                        ProgressManager.checkCanceled();
                        implementors.add(sub);
                        return true;
                    })) continue;
                    return false;
                }
                for (PsiMethod implementor : implementors) {
                    ProgressManager.checkCanceled();
                    if (!parent.params.scope.contains((PsiElement)implementor)) continue;
                    if (implementor instanceof PsiCompiledElement) {
                        implementor = (PsiMethod)implementor.getNavigationElement();
                    }
                    PsiParameter[] parameters2 = implementor.getParameterList().getParameters();
                    if (index == -1 || index >= parameters2.length) continue;
                    parametersToAnalyze.add(parameters2[index]);
                }
            } else {
                parametersToAnalyze.add(parameter2);
            }
            for (PsiParameter psiParameter : parametersToAnalyze) {
                ProgressManager.checkCanceled();
                if (SliceForwardUtil.searchReferencesAndProcessAssignmentTarget((PsiElement)psiParameter, null, parent, processor)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof PsiField) {
            return SliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, null, parent, processor);
        }
        if (from instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)from;
            THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
            superMethods.add(method);
            THashSet processed = new THashSet();
            for (PsiMethod containingMethod : superMethods) {
                if (MethodReferencesSearch.search((PsiMethod)containingMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(arg_0 -> SliceForwardUtil.lambda$processAssignedFrom$2((Set)processed, parent, processor, arg_0))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean searchReferencesAndProcessAssignmentTarget(@NotNull PsiElement element, @Nullable PsiElement context, @NotNull JavaSliceUsage parent, @NotNull Processor<? super SliceUsage> processor) {
        return ReferencesSearch.search((PsiElement)element).forEach(reference -> {
            PsiElement element1 = reference.getElement();
            if (context != null && element1.getTextOffset() < context.getTextOffset()) {
                return true;
            }
            return SliceForwardUtil.processAssignmentTarget(element1, parent, processor);
        });
    }

    private static boolean processAssignmentTarget(@NotNull PsiElement element, @NotNull JavaSliceUsage parent, @NotNull Processor<? super SliceUsage> processor) {
        if (!parent.params.scope.contains(element)) {
            return true;
        }
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return SliceUtil.createAndProcessSliceUsage(element, parent, (PsiSubstitutor)EmptySubstitutor.getInstance(), parent.indexNesting, "", processor);
        }
        Pair<PsiElement, PsiSubstitutor> pair = SliceForwardUtil.getAssignmentTarget(element, parent);
        if (pair != null) {
            return SliceUtil.createAndProcessSliceUsage(element, parent, (PsiSubstitutor)pair.getSecond(), parent.indexNesting, "", processor);
        }
        if (parent.params.showInstanceDereferences && SliceForwardUtil.isDereferenced(element)) {
            JavaSliceDereferenceUsage usage = new JavaSliceDereferenceUsage(element.getParent(), parent, parent.getSubstitutor());
            return processor.process((Object)usage);
        }
        return true;
    }

    private static PsiExpression getMethodCallTarget(PsiElement element) {
        PsiExpression value2;
        element = SliceForwardUtil.complexify(element);
        PsiMethodCallExpression call = null;
        if (element.getParent() instanceof PsiExpressionList) {
            call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element.getParent().getParent(), PsiMethodCallExpression.class);
        }
        return (value2 = JavaMethodContractUtil.findReturnedValue(call)) == element ? call : null;
    }

    private static boolean isDereferenced(@NotNull PsiElement element) {
        if (!(element instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        return ((PsiReferenceExpression)parent).getQualifierExpression() == element;
    }

    private static Pair<PsiElement, PsiSubstitutor> getAssignmentTarget(@NotNull PsiElement element, @NotNull JavaSliceUsage parentUsage) {
        PsiMethodCallExpression call;
        PsiExpression maybeQualifier;
        element = SliceForwardUtil.complexify(element);
        PsiVariable target = null;
        PsiSubstitutor substitutor = parentUsage.getSubstitutor();
        PsiElement parent = element.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression left;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            if (element.equals(assignment.getRExpression()) && (left = assignment.getLExpression()) instanceof PsiReferenceExpression) {
                JavaResolveResult result = ((PsiReferenceExpression)left).advancedResolve(false);
                target = result.getElement();
                substitutor = result.getSubstitutor();
            }
        } else if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiExpression initializer = variable.getInitializer();
            if (element.equals(initializer)) {
                target = variable;
            }
        } else if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression) {
            PsiParameter[] parameters2;
            Object[] expressions2 = ((PsiExpressionList)parent).getExpressions();
            int index = ArrayUtilRt.find((Object[])expressions2, (Object)element);
            PsiCallExpression methodCall = (PsiCallExpression)parent.getParent();
            JavaResolveResult result = methodCall.resolveMethodGenerics();
            PsiMethod method = (PsiMethod)result.getElement();
            if (index != -1 && method != null && index < (parameters2 = method.getParameterList().getParameters()).length) {
                target = parameters2[index];
                substitutor = result.getSubstitutor();
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiReturnStatement statement = (PsiReturnStatement)parent;
            if (element.equals(statement.getReturnValue())) {
                target = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            }
        } else if (element instanceof PsiExpression && (maybeQualifier = JavaMethodContractUtil.findReturnedValue(call = ExpressionUtils.getCallForQualifier((PsiExpression)element))) == element) {
            target = call;
        }
        return target == null ? null : Pair.create(target, (Object)substitutor);
    }

    @NotNull
    static PsiElement complexify(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiParenthesizedExpression && element.equals(((PsiParenthesizedExpression)parent).getExpression())) {
            return SliceForwardUtil.complexify(parent);
        }
        if (parent instanceof PsiTypeCastExpression && element.equals(((PsiTypeCastExpression)parent).getOperand())) {
            return SliceForwardUtil.complexify(parent);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$processAssignedFrom$2(Set processed, JavaSliceUsage parent, Processor processor, PsiReference reference) {
        ProgressManager.checkCanceled();
        Set set = processed;
        synchronized (set) {
            if (!processed.add(reference)) {
                return true;
            }
        }
        PsiElement element = reference.getElement().getParent();
        return SliceForwardUtil.processAssignmentTarget(element, parent, (Processor<? super SliceUsage>)processor);
    }
}

