/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceForwardUtil;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SliceUtil {
    SliceUtil() {
    }

    static boolean processUsagesFlownDownTo(@NotNull PsiElement expression2, @NotNull Processor<? super SliceUsage> processor, @NotNull JavaSliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField) {
        int parametersCount;
        PsiMethod method;
        PsiElement par;
        assert (indexNesting >= 0) : indexNesting;
        PsiElement original = expression2 = SliceUtil.simplify(expression2);
        if (expression2 instanceof PsiArrayAccessExpression) {
            expression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            ++indexNesting;
        }
        PsiElement psiElement = par = expression2 == null ? null : expression2.getParent();
        if (expression2 instanceof PsiExpressionList && par instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)par).resolveMethod()) != null && (parametersCount = method.getParameterList().getParametersCount()) != 0) {
            PsiExpression[] expressions2 = ((PsiExpressionList)expression2).getExpressions();
            if (indexNesting != 0) {
                for (int i = parametersCount - 1; i < expressions2.length; ++i) {
                    PsiExpression arg = expressions2[i];
                    if (SliceUtil.handToProcessor((PsiElement)arg, processor, parent, parentSubstitutor, indexNesting - 1, syntheticField)) continue;
                    return false;
                }
            }
            return true;
        }
        boolean needToReportDeclaration = false;
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement element = SliceForwardUtil.complexify(expression2);
            if (element instanceof PsiExpression && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) {
                PsiExpression rightSide = ((PsiAssignmentExpression)element.getParent()).getRExpression();
                return rightSide == null || SliceUtil.handToProcessor((PsiElement)rightSide, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)expression2;
            JavaResolveResult result = ref.advancedResolve(false);
            parentSubstitutor = result.getSubstitutor().putAll(parentSubstitutor);
            PsiElement resolved = result.getElement();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            if (resolved instanceof PsiMethod && expression2.getParent() instanceof PsiMethodCallExpression) {
                return SliceUtil.processUsagesFlownDownTo(expression2.getParent(), processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            SliceUtil.addContainerReferences((PsiVariable)resolved, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            needToReportDeclaration = true;
            expression2 = resolved;
        }
        if (expression2 instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)expression2;
            Collection<PsiExpression> values = DfaUtil.getCachedVariableValues(variable, original);
            if (values == null) {
                return SliceUtil.createAndProcessTooComplexDFAUsage(expression2, parent, processor);
            }
            PsiExpression initializer = variable.getInitializer();
            if (values.isEmpty() && initializer != null) {
                values = Collections.singletonList(initializer);
            }
            boolean initializerReported = false;
            if (values.isEmpty() && !(variable instanceof PsiParameter) && !needToReportDeclaration) {
                values = DfaPsiUtil.getVariableAssignmentsInFile(variable, false, variable.getContainingFile().getLastChild());
                initializerReported = !values.isEmpty();
            } else if (!values.isEmpty() && !(variable instanceof PsiParameter)) {
                needToReportDeclaration = false;
            }
            for (PsiExpression exp : values) {
                if (!SliceUtil.handToProcessor((PsiElement)exp, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                    return false;
                }
                if (exp != initializer) continue;
                initializerReported = true;
            }
            if (!initializerReported && needToReportDeclaration) {
                return SliceUtil.handToProcessor((PsiElement)variable, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
            if (variable instanceof PsiField) {
                return SliceUtil.processFieldUsages((PsiField)variable, parent, parentSubstitutor, processor);
            }
            if (variable instanceof PsiParameter) {
                return SliceUtil.processParameterUsages((PsiParameter)variable, parent, parentSubstitutor, indexNesting, syntheticField, processor);
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            Flow anno;
            PsiExpression returnedValue = JavaMethodContractUtil.findReturnedValue((PsiMethodCallExpression)expression2);
            if (returnedValue != null && !SliceUtil.handToProcessor((PsiElement)returnedValue, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                return false;
            }
            PsiMethod method2 = ((PsiMethodCallExpression)expression2).resolveMethod();
            Flow flow = anno = method2 == null ? null : SliceUtil.isMethodFlowAnnotated(method2);
            if (anno != null) {
                PsiExpression qualifier;
                String target = anno.target();
                if (target.equals("This container (if the parameter was annotated) or the return value (if instance method was annotated)")) {
                    target = "The return value of this method";
                }
                if (target.equals("The return value of this method") && (qualifier = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression()) != null) {
                    int nesting = SliceUtil.calcNewIndexNesting(indexNesting, anno);
                    String source = anno.source();
                    if (source.equals("The method argument (if parameter was annotated) or this container (if instance method was annotated)")) {
                        source = "this";
                    }
                    String synthetic = StringUtil.trimStart((String)StringUtil.trimStart((String)source, (String)"this"), (String)".");
                    return SliceUtil.processUsagesFlownDownTo((PsiElement)qualifier, processor, parent, parentSubstitutor, nesting, synthetic);
                }
            }
            return SliceUtil.processMethodReturnValue((PsiMethodCallExpression)expression2, processor, parent, parentSubstitutor);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            if (thenE != null && !SliceUtil.handToProcessor((PsiElement)thenE, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                return false;
            }
            if (elseE != null && !SliceUtil.handToProcessor((PsiElement)elseE, processor, parent, parentSubstitutor, indexNesting, syntheticField)) {
                return false;
            }
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression rExpression = assignment.getRExpression();
            if (tokenType == JavaTokenType.EQ && rExpression != null) {
                return SliceUtil.processUsagesFlownDownTo((PsiElement)rExpression, processor, parent, parentSubstitutor, indexNesting, syntheticField);
            }
        }
        if (indexNesting != 0) {
            PsiElement initializer;
            Object object = initializer = expression2 instanceof PsiNewExpression ? ((PsiNewExpression)expression2).getArrayInitializer() : expression2;
            if (initializer instanceof PsiArrayInitializerExpression) {
                for (PsiExpression init : ((PsiArrayInitializerExpression)initializer).getInitializers()) {
                    if (SliceUtil.handToProcessor((PsiElement)init, processor, parent, parentSubstitutor, indexNesting - 1, syntheticField)) continue;
                    return false;
                }
            }
            return !(expression2 instanceof PsiNewExpression) || SliceUtil.processContainerPutArguments((PsiCallExpression)((PsiNewExpression)expression2), parent, parentSubstitutor, indexNesting, syntheticField, processor);
        }
        return true;
    }

    private static Flow isMethodFlowAnnotated(@NotNull PsiMethod method) {
        return (Flow)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Flow.class);
    }

    private static Flow isParamFlowAnnotated(@NotNull PsiMethod method, int paramIndex) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length <= paramIndex) {
            if (parameters2.length != 0 && parameters2[parameters2.length - 1].isVarArgs()) {
                paramIndex = parameters2.length - 1;
            } else {
                return null;
            }
        }
        return (Flow)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)parameters2[paramIndex], Flow.class);
    }

    private static PsiElement simplify(@NotNull PsiElement expression2) {
        return expression2 instanceof PsiExpression ? PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)expression2)) : expression2;
    }

    private static boolean handToProcessor(@NotNull PsiElement expression2, @NotNull Processor<? super SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, int indexNesting, @NotNull String syntheticField) {
        PsiElement realExpression;
        PsiElement psiElement = realExpression = expression2.getParent() instanceof DummyHolder ? expression2.getParent().getContext() : expression2;
        assert (realExpression != null);
        if (!(realExpression instanceof PsiCompiledElement)) {
            return SliceUtil.createAndProcessSliceUsage(realExpression, parent, substitutor, indexNesting, syntheticField, processor);
        }
        return true;
    }

    @NotNull
    static Collection<SliceUsage> collectMethodReturnValues(@NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, PsiMethod methodCalled) {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SliceUtil.processMethodReturnValue((Processor<? super SliceUsage>)processor, parent, parentSubstitutor, null, methodCalled, null, PsiSubstitutor.EMPTY);
        return processor.getResults();
    }

    private static boolean processMethodReturnValue(@NotNull PsiMethodCallExpression methodCallExpr, @NotNull Processor<? super SliceUsage> processor, @NotNull JavaSliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor) {
        PsiClass qualifierClass = SliceUtil.resolveQualifier(methodCallExpr);
        JavaResolveResult resolved = methodCallExpr.resolveMethodGenerics();
        PsiElement r = resolved.getElement();
        if (r instanceof PsiCompiledElement) {
            r = r.getNavigationElement();
        }
        if (!(r instanceof PsiMethod)) {
            return true;
        }
        PsiMethod methodCalled = (PsiMethod)r;
        PsiType returnType = methodCalled.getReturnType();
        if (returnType == null) {
            return true;
        }
        PsiType parentType = parentSubstitutor.substitute(methodCallExpr.getType());
        PsiSubstitutor substitutor = resolved.getSubstitutor().putAll(parentSubstitutor);
        return SliceUtil.processMethodReturnValue(processor, parent, parentSubstitutor, qualifierClass, methodCalled, parentType, substitutor);
    }

    private static boolean processMethodReturnValue(final @NotNull Processor<? super SliceUsage> processor, final @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, @Nullable PsiClass qualifierClass, PsiMethod methodCalled, final @Nullable PsiType parentType, final @NotNull PsiSubstitutor substitutor) {
        THashSet overrides = new THashSet();
        OverridingMethodsSearch.search((PsiMethod)methodCalled, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(arg_0 -> SliceUtil.lambda$processMethodReturnValue$0(qualifierClass, (Collection)overrides, arg_0));
        overrides.add(methodCalled);
        final int indexNesting = parent instanceof JavaSliceUsage ? ((JavaSliceUsage)parent).indexNesting : 0;
        final boolean[] result = new boolean[]{true};
        for (PsiMethod override : overrides) {
            if (!result[0]) break;
            if (override instanceof PsiCompiledElement) {
                override = (PsiMethod)override.getNavigationElement();
            }
            if (!parent.getScope().contains((PsiElement)override)) continue;
            Language language = override.getLanguage();
            if (language != JavaLanguage.INSTANCE) {
                SliceUtil.handToProcessor((PsiElement)override, processor, parent, substitutor, indexNesting, "");
                continue;
            }
            PsiCodeBlock body2 = override.getBody();
            if (body2 == null) continue;
            PsiSubstitutor s = methodCalled == override ? substitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodCalled.getSignature(substitutor), (MethodSignature)override.getSignature(substitutor));
            final PsiSubstitutor superSubstitutor = s == null ? parentSubstitutor : s;
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiExpression returnValue = statement.getReturnValue();
                    if (returnValue == null) {
                        return;
                    }
                    PsiType right = superSubstitutor.substitute(superSubstitutor.substitute(returnValue.getType()));
                    if (right == null || parentType != null && !TypeConversionUtil.isAssignable((PsiType)parentType, (PsiType)right)) {
                        return;
                    }
                    if (!SliceUtil.handToProcessor((PsiElement)returnValue, (Processor<? super SliceUsage>)processor, parent, substitutor, indexNesting, "")) {
                        this.stopWalking();
                        result[0] = false;
                    }
                }
            });
        }
        return result[0];
    }

    private static PsiClass resolveQualifier(@NotNull PsiMethodCallExpression expr) {
        PsiExpression qualifier = expr.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            PsiMethodCallExpression copy = (PsiMethodCallExpression)expr.copy();
            PsiReferenceExpression methodExpression = copy.getMethodExpression();
            PsiThisExpression thisExpression = RefactoringChangeUtil.createThisExpression(expr.getManager(), null);
            methodExpression.setQualifierExpression((PsiExpression)thisExpression);
            qualifier = methodExpression.getQualifierExpression();
        }
        if (qualifier != null) {
            PsiType type2;
            if (qualifier instanceof PsiReferenceExpression) {
                PsiElement resolved = ((PsiReferenceExpression)qualifier).resolve();
                if (resolved instanceof PsiClass) {
                    return (PsiClass)resolved;
                }
            } else if ((qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (type2 = qualifier.getType()) instanceof PsiClassType) {
                return ((PsiClassType)type2).resolve();
            }
        }
        return null;
    }

    private static boolean processFieldUsages(@NotNull PsiField field, @NotNull JavaSliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, @NotNull Processor<? super SliceUsage> processor) {
        PsiExpression initializer;
        if (field.hasInitializer() && (initializer = field.getInitializer()) != null && !(field instanceof PsiCompiledElement) && !SliceUtil.handToProcessor((PsiElement)initializer, processor, parent, parentSubstitutor, parent.indexNesting, "")) {
            return false;
        }
        SearchScope searchScope = parent.getScope().toSearchScope();
        return ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope).forEach(reference -> {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            if (element instanceof PsiCompiledElement) {
                element = element.getNavigationElement();
                if (!parent.getScope().contains(element)) {
                    return true;
                }
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parentExpr = referenceExpression.getParent();
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referenceExpression)) {
                    PsiExpression rExpression = ((PsiAssignmentExpression)parentExpr).getRExpression();
                    PsiType rtype = rExpression.getType();
                    PsiType ftype = field.getType();
                    PsiType subFType = parentSubstitutor.substitute(ftype);
                    PsiType subRType = parentSubstitutor.substitute(rtype);
                    if (subFType != null && subRType != null && TypeConversionUtil.isAssignable((PsiType)subFType, (PsiType)subRType)) {
                        return SliceUtil.handToProcessor((PsiElement)rExpression, processor, parent, parentSubstitutor, parent.indexNesting, "");
                    }
                }
                if (parentExpr instanceof PsiUnaryExpression && ((PsiUnaryExpression)parentExpr).getOperand() == referenceExpression && (((PsiUnaryExpression)parentExpr).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiUnaryExpression)parentExpr).getOperationTokenType() == JavaTokenType.MINUSMINUS)) {
                    PsiUnaryExpression unaryExpression = (PsiUnaryExpression)parentExpr;
                    return SliceUtil.handToProcessor((PsiElement)unaryExpression, processor, parent, parentSubstitutor, parent.indexNesting, "");
                }
            }
            return SliceUtil.processIfInForeignLanguage(parent, parentSubstitutor, 0, "", processor, element);
        });
    }

    static boolean createAndProcessSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, int indexNesting, @NotNull String syntheticField, @NotNull Processor<? super SliceUsage> processor) {
        PsiElement simplified = SliceUtil.simplify(element);
        return simplified == null || processor.process((Object)new JavaSliceUsage(simplified, parent, substitutor, indexNesting, syntheticField));
    }

    private static boolean createAndProcessTooComplexDFAUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull Processor<? super SliceUsage> processor) {
        PsiElement simplified = SliceUtil.simplify(element);
        return simplified == null || processor.process((Object)new SliceTooComplexDFAUsage(simplified, parent));
    }

    private static boolean processParameterUsages(@NotNull PsiParameter parameter2, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField, @NotNull Processor<? super SliceUsage> processor) {
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (declarationScope instanceof PsiForeachStatement) {
            PsiForeachStatement statement = (PsiForeachStatement)declarationScope;
            PsiExpression iterated = statement.getIteratedValue();
            return statement.getIterationParameter() != parameter2 || iterated == null || SliceUtil.handToProcessor((PsiElement)iterated, processor, parent, parentSubstitutor, indexNesting + 1, syntheticField);
        }
        if (!(declarationScope instanceof PsiMethod)) {
            return true;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        PsiType actualParameterType = parameter2.getType();
        Object[] actualParameters = method.getParameterList().getParameters();
        int paramSeqNo = ArrayUtilRt.find((Object[])actualParameters, (Object)parameter2);
        assert (paramSeqNo != -1);
        PsiCall specificMethodCall = SliceUtil.findSpecificMethodCallUpTheTree(parent, method);
        if (specificMethodCall != null) {
            return SliceUtil.processMethodCall(parent, parentSubstitutor, indexNesting, syntheticField, processor, actualParameterType, (PsiParameter[])actualParameters, paramSeqNo, (PsiElement)specificMethodCall);
        }
        THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
        superMethods.add(method);
        THashSet processed = new THashSet();
        for (PsiMethod superMethod : superMethods) {
            if (MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(arg_0 -> SliceUtil.lambda$processParameterUsages$2((Set)processed, parent, parentSubstitutor, indexNesting, syntheticField, processor, actualParameterType, (PsiParameter[])actualParameters, paramSeqNo, arg_0))) continue;
            return false;
        }
        return true;
    }

    private static PsiCall findSpecificMethodCallUpTheTree(SliceUsage parent, PsiMethod method) {
        while (parent != null) {
            PsiElement element = parent.getElement();
            if (element instanceof PsiCall && ((PsiCall)element).resolveMethod() == method) {
                return (PsiCall)element;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static boolean processMethodCall(@NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField, @NotNull Processor<? super SliceUsage> processor, PsiType actualParameterType, PsiParameter[] actualParameters, int paramSeqNo, PsiElement refElement) {
        PsiType typeToCheck;
        PsiSubstitutor combined;
        PsiType actualExpressionType;
        PsiExpressionList passExpression;
        JavaResolveResult result;
        PsiExpressionList argumentList;
        if (refElement instanceof PsiCall) {
            PsiCall call = (PsiCall)refElement;
            argumentList = call.getArgumentList();
            result = call.resolveMethodGenerics();
        } else {
            PsiElement element = refElement.getParent();
            if (element instanceof PsiCompiledElement) {
                return true;
            }
            if (element instanceof PsiAnonymousClass) {
                PsiAnonymousClass anon = (PsiAnonymousClass)element;
                argumentList = anon.getArgumentList();
                PsiElement callExp = element.getParent();
                if (!(callExp instanceof PsiCallExpression)) {
                    return true;
                }
                result = ((PsiCall)callExp).resolveMethodGenerics();
            } else if (element instanceof PsiCall) {
                PsiCall call = (PsiCall)element;
                argumentList = call.getArgumentList();
                result = call.resolveMethodGenerics();
            } else {
                return SliceUtil.processIfInForeignLanguage(parent, parentSubstitutor, indexNesting, syntheticField, processor, refElement);
            }
        }
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (paramSeqNo >= expressions2.length) {
            return true;
        }
        if (actualParameterType instanceof PsiEllipsisType) {
            passExpression = argumentList;
            actualExpressionType = expressions2[paramSeqNo].getType();
        } else {
            passExpression = expressions2[paramSeqNo];
            actualExpressionType = ((PsiExpression)passExpression).getType();
        }
        Project project = argumentList.getProject();
        PsiElement element = result.getElement();
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        if (element instanceof PsiTypeParameterListOwner && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)element), (PsiSubstitutor)substitutor)) {
            PsiTypeParameter[] typeParameters = substitutor.getSubstitutionMap().keySet().toArray(PsiTypeParameter.EMPTY_ARRAY);
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
            substitutor = resolveHelper.inferTypeArguments(typeParameters, actualParameters, expressions2, parentSubstitutor, (PsiElement)argumentList, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
        }
        if ((combined = SliceUtil.unify(substitutor = SliceUtil.removeRawMappingsLeftFromResolve(substitutor), parentSubstitutor, project)) == null) {
            return true;
        }
        PsiType substituted = combined.substitute(actualExpressionType);
        if (substituted instanceof PsiPrimitiveType) {
            PsiClassType boxedType = ((PsiPrimitiveType)substituted).getBoxedType((PsiElement)argumentList);
            Object object = substituted = boxedType != null ? boxedType : substituted;
        }
        if (substituted == null) {
            return true;
        }
        if (actualParameterType instanceof PsiEllipsisType) {
            if (TypeConversionUtil.areTypesConvertible((PsiType)substituted, (PsiType)actualParameterType)) {
                return SliceUtil.handToProcessor((PsiElement)expressions2[paramSeqNo], processor, parent, combined, indexNesting, syntheticField);
            }
            typeToCheck = ((PsiEllipsisType)actualParameterType).getComponentType();
        } else {
            typeToCheck = actualParameterType;
        }
        if (!TypeConversionUtil.areTypesConvertible((PsiType)substituted, (PsiType)typeToCheck)) {
            return true;
        }
        return SliceUtil.handToProcessor((PsiElement)passExpression, processor, parent, combined, indexNesting, syntheticField);
    }

    private static boolean processIfInForeignLanguage(@NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField, @NotNull Processor<? super SliceUsage> processor, @NotNull PsiElement foreignElement) {
        PsiFile file = foreignElement.getContainingFile();
        if (file != null && file.getLanguage() != JavaLanguage.INSTANCE) {
            return SliceUtil.handToProcessor(foreignElement, processor, parent, parentSubstitutor, indexNesting, syntheticField);
        }
        return true;
    }

    private static void addContainerReferences(@NotNull PsiVariable variable, @NotNull Processor<? super SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField) {
        if (indexNesting != 0) {
            ReferencesSearch.search((PsiElement)variable).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (element instanceof PsiExpression && !element.getManager().areElementsEquivalent(element, parent.getElement())) {
                    PsiExpression expression2 = (PsiExpression)element;
                    return SliceUtil.addContainerItemModification(expression2, processor, parent, parentSubstitutor, indexNesting, syntheticField);
                }
                return true;
            });
        }
    }

    private static boolean addContainerItemModification(@NotNull PsiExpression expression2, @NotNull Processor<? super SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField) {
        PsiElement grand;
        PsiElement parentElement = expression2.getParent();
        if (parentElement instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)parentElement).getArrayExpression() == expression2 && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)parentElement)) && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)parentElement))) {
            PsiExpression rightSide = ((PsiAssignmentExpression)parentElement.getParent()).getRExpression();
            return rightSide == null || SliceUtil.handToProcessor((PsiElement)rightSide, processor, parent, parentSubstitutor, indexNesting - 1, syntheticField);
        }
        PsiElement psiElement = grand = parentElement == null ? null : parentElement.getParent();
        if (grand instanceof PsiCallExpression) {
            return SliceUtil.processContainerPutArguments((PsiCallExpression)grand, parent, parentSubstitutor, indexNesting, syntheticField, processor);
        }
        return true;
    }

    private static boolean processContainerPutArguments(@NotNull PsiCallExpression call, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, int indexNesting, @NotNull String syntheticField, @NotNull Processor<? super SliceUsage> processor) {
        assert (indexNesting != 0);
        JavaResolveResult result = call.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        if (method != null) {
            int parametersCount = method.getParameterList().getParametersCount();
            Flow[] annotations2 = new Flow[parametersCount];
            for (int i = 0; i < parametersCount; ++i) {
                annotations2[i] = SliceUtil.isParamFlowAnnotated(method, i);
            }
            PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            for (int i = 0; i < expressions2.length; ++i) {
                PsiParameter parameter2;
                Flow anno;
                PsiExpression argument = expressions2[i];
                if (i >= parameters2.length) {
                    if (parameters2.length == 0 || !parameters2[parameters2.length - 1].isVarArgs()) break;
                    anno = annotations2[parameters2.length - 1];
                    parameter2 = parameters2[parameters2.length - 1];
                } else {
                    anno = annotations2[i];
                    parameter2 = parameters2[i];
                }
                if (anno != null) {
                    int nesting;
                    PsiSubstitutor substitutor;
                    String paramSynthetic;
                    String target = anno.target();
                    if (target.equals("This container (if the parameter was annotated) or the return value (if instance method was annotated)")) {
                        target = "this";
                    }
                    if (target.startsWith("this") && (paramSynthetic = StringUtil.trimStart((String)StringUtil.trimStart((String)target, (String)"this"), (String)".")).equals(syntheticField) && !SliceUtil.handToProcessor((PsiElement)argument, processor, parent, substitutor = SliceUtil.unify(result.getSubstitutor(), parentSubstitutor, argument.getProject()), nesting = SliceUtil.calcNewIndexNesting(indexNesting, anno), paramSynthetic)) {
                        return false;
                    }
                }
                for (int si = 0; si < annotations2.length; ++si) {
                    Flow sourceAnno;
                    if (si == i || (sourceAnno = annotations2[si]) == null || !sourceAnno.target().equals(parameter2.getName())) continue;
                    int newNesting = SliceUtil.calcNewIndexNesting(indexNesting, sourceAnno);
                    PsiExpression sourceArgument = expressions2[si];
                    PsiSubstitutor substitutor = SliceUtil.unify(result.getSubstitutor(), parentSubstitutor, argument.getProject());
                    if (SliceUtil.handToProcessor((PsiElement)sourceArgument, processor, parent, substitutor, newNesting, syntheticField)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int calcNewIndexNesting(int indexNesting, @NotNull Flow anno) {
        int nestingDelta = (anno.sourceIsContainer() ? 1 : 0) - (anno.targetIsContainer() ? 1 : 0);
        return indexNesting + nestingDelta;
    }

    @NotNull
    private static PsiSubstitutor removeRawMappingsLeftFromResolve(@NotNull PsiSubstitutor substitutor) {
        Map map2 = null;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            if (entry.getValue() != null) continue;
            if (map2 == null) {
                map2 = new THashMap();
            }
            map2.put(entry.getKey(), entry.getValue());
        }
        if (map2 == null) {
            return substitutor;
        }
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        newMap.keySet().removeAll(map2.keySet());
        return PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)newMap);
    }

    @Nullable
    private static PsiSubstitutor unify(@NotNull PsiSubstitutor substitutor, @NotNull PsiSubstitutor parentSubstitutor, @NotNull Project project) {
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            PsiType type2 = (PsiType)entry.getValue();
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type2);
            if (!parentSubstitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType parentType = parentSubstitutor.substitute(parentSubstitutor.substitute(typeParameter));
            if (resolved instanceof PsiTypeParameter) {
                PsiTypeParameter res = (PsiTypeParameter)resolved;
                newMap.put(res, parentType);
                continue;
            }
            if (Comparing.equal((Object)type2, (Object)parentType)) continue;
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createSubstitutor((Map)newMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$processParameterUsages$2(Set processed, SliceUsage parent, PsiSubstitutor parentSubstitutor, int indexNesting, String syntheticField, Processor processor, PsiType actualParameterType, PsiParameter[] actualParameters, int paramSeqNo, PsiReference reference) {
        ProgressManager.checkCanceled();
        Set set = processed;
        synchronized (set) {
            if (!processed.add(reference)) {
                return true;
            }
        }
        PsiElement refElement = reference.getElement();
        return SliceUtil.processMethodCall(parent, parentSubstitutor, indexNesting, syntheticField, (Processor<? super SliceUsage>)processor, actualParameterType, actualParameters, paramSeqNo, refElement);
    }

    private static /* synthetic */ boolean lambda$processMethodReturnValue$0(PsiClass qualifierClass, Collection overrides, PsiMethod override) {
        PsiClass containingClass = override.getContainingClass();
        if (containingClass == null) {
            return true;
        }
        if (qualifierClass == null || containingClass.isInheritor(qualifierClass, true)) {
            overrides.add(override);
        }
        return true;
    }
}

