/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.intention;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToSetUpMethodAction
extends BaseMoveInitializerToMethodAction {
    private static final Logger LOG = Logger.getInstance(MoveInitializerToSetUpMethodAction.class);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.move.initializer.to.set.up", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean isAvailable = super.isAvailable(project, editor, element);
        if (isAvailable) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            LOG.assertTrue(field != null);
            PsiClass aClass = field.getContainingClass();
            LOG.assertTrue(aClass != null);
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)aClass);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            if (testFramework instanceof JavaTestFramework) {
                try {
                    ((JavaTestFramework)testFramework).createSetUpPatternMethod((JVMElementFactory)elementFactory);
                    return testFramework.isTestClass((PsiElement)aClass) || testFramework.findSetUpMethod((PsiElement)aClass) instanceof PsiMethod;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        return Arrays.asList("static", "final");
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project, @NotNull Editor editor, PsiFile file, @NotNull PsiClass aClass) {
        TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)aClass);
        PsiElement setUpMethod = null;
        if (testFramework != null && (setUpMethod = testFramework.findSetUpMethod((PsiElement)aClass)) == null) {
            setUpMethod = testFramework.findOrCreateSetUpMethod((PsiElement)aClass);
        }
        return setUpMethod instanceof PsiMethod ? Collections.singletonList((PsiMethod)setUpMethod) : Collections.emptyList();
    }
}

