/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import org.jetbrains.annotations.NotNull;

public class JavaUsageViewDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (location instanceof UsageViewShortNameLocation) {
            if (element instanceof PsiThrowStatement) {
                return UsageViewBundle.message((String)"usage.target.exception", (Object[])new Object[0]);
            }
            if (element instanceof PsiAnonymousClass) {
                String name = ((PsiAnonymousClass)element).getBaseClassReference().getReferenceName();
                return "anonymous " + StringUtil.notNullize((String)name, (String)"class");
            }
            if (element instanceof PsiClassInitializer) {
                boolean isStatic = ((PsiClassInitializer)element).hasModifierProperty("static");
                return isStatic ? "<clinit>" : "<init>";
            }
        }
        if (location instanceof UsageViewLongNameLocation) {
            if (element instanceof PsiPackage) {
                return ((PsiPackage)element).getQualifiedName();
            }
            if (element instanceof PsiClass) {
                if (element instanceof PsiAnonymousClass) {
                    String name = ((PsiAnonymousClass)element).getBaseClassReference().getReferenceName();
                    return "anonymous " + StringUtil.notNullize((String)name, (String)"class");
                }
                String ret = ((PsiClass)element).getQualifiedName();
                if (ret == null) {
                    ret = ((PsiClass)element).getName();
                }
                return ret;
            }
            if (element instanceof PsiVariable) {
                return ((PsiVariable)element).getName();
            }
            if (element instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)element;
                return PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            }
        }
        return null;
    }
}

