/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageConverter
extends Converter<PsiPackage>
implements CustomReferenceConverter<PsiPackage> {
    public PsiPackage fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject()).findPackage(s);
    }

    public String toString(@Nullable PsiPackage psiPackage, ConvertContext context) {
        return psiPackage == null ? null : psiPackage.getQualifiedName();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiPackage> genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        GlobalSearchScope scope = context.getSearchScope();
        return new PackageReferenceSet(s, element, ElementManipulators.getOffsetInElement((PsiElement)element), scope != null ? scope : GlobalSearchScope.allScope((Project)element.getProject())).getPsiReferences();
    }
}

