/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodUtil {
    private static final int MAX_OVERRIDDEN_METHOD_SEARCH = 20;

    @Nullable
    public static Stream<PsiMethod> getOverridingMethodsIfCheapEnough(@NotNull PsiMethod method, @Nullable GlobalSearchScope searchScope, @NotNull Predicate<? super PsiMethod> preFilter) {
        Project project = method.getProject();
        String name = method.getName();
        SearchScope useScope = method.getUseScope();
        GlobalSearchScope effectiveSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)useScope, (Project)project);
        if (searchScope != null) {
            effectiveSearchScope = effectiveSearchScope.intersectWith(searchScope);
        }
        ArrayList methods = ContainerUtil.newArrayList();
        if (!StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, project, (GlobalSearchScope)new JavaSourceFilterScope(effectiveSearchScope), PsiMethod.class, m -> {
            ProgressManager.checkCanceled();
            if (m == method) {
                return true;
            }
            if (!preFilter.test((PsiMethod)m)) {
                return true;
            }
            methods.add(m);
            return methods.size() <= 20;
        })) {
            return null;
        }
        return methods.stream().filter(candidate -> PsiSuperMethodUtil.isSuperMethod((PsiMethod)candidate, (PsiMethod)method));
    }

    public static boolean containsAnnotationWithName(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String shortAnnotationName) {
        PsiModifierList list = modifierListOwner.getModifierList();
        if (list != null) {
            for (PsiAnnotation annotation : list.getAnnotations()) {
                PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                if (ref == null || !shortAnnotationName.equals(ref.getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }
}

