/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReplacementUtil {
    public static void replaceExpression(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
        PsiElement replacementExpression = expression2.replace((PsiElement)newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        styleManager.reformat(replacementExpression);
    }

    public static void replaceExpression(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        Project project = expression2.getProject();
        PsiElement replacementExpression = tracker.replaceAndRestoreComments((PsiElement)expression2, newExpressionText);
        CodeStyleManager.getInstance((Project)project).reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression2);
        PsiElement replacementExp = expression2.replace((PsiElement)newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        Project project = expression2.getProject();
        PsiElement replacementExp = tracker.replaceAndRestoreComments((PsiElement)expression2, newExpressionText);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)statement);
        PsiElement replacementExp = statement.replace((PsiElement)newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, CommentTracker commentTracker) {
        Project project = statement.getProject();
        PsiElement replacementExp = commentTracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        PsiReplacementUtil.replaceStatementAndShortenClassNames(statement, newStatementText, null);
    }

    public static PsiElement replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, @Nullable CommentTracker tracker) {
        PsiStatement newStatement;
        Project project = statement.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (tracker != null) {
            newStatement = (PsiStatement)tracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            newStatement = (PsiStatement)statement.replace((PsiElement)factory.createStatementFromText(newStatementText, (PsiElement)statement));
        }
        return styleManager.reformat(javaStyleManager.shortenClassReferences((PsiElement)newStatement));
    }

    public static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression2, @NotNull PsiMember target) {
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory.createExpressionFromText("xxx", (PsiElement)expression2);
        CommentTracker tracker = new CommentTracker();
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)tracker.replaceAndRestoreComments((PsiElement)expression2, (PsiElement)newExpression);
        PsiElement element = replacementExpression.bindToElement((PsiElement)target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        styleManager.shortenClassReferences(element);
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        return out.toString();
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public static void replaceOperatorAssignmentWithAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator2 = sign.getText();
        String newOperator = operator2.substring(0, operator2.length() - 1);
        String lhsText = tracker.text((PsiElement)lhs);
        String rhsText = rhs == null ? "" : tracker.text((PsiElement)rhs);
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = PsiReplacementUtil.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpression.toString(), tracker);
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType((PsiType)rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion((PsiType)lType, (PsiType)rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) || !TypeConversionUtil.areTypesConvertible((PsiType)lType, (PsiType)rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }
}

